const pg = require('pg');
const moment = require('moment');
const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);
const { haversineDistance } = require('./haversine');
const all_user_notification = require('./all_user_notification_function');

const base_img_url = 'http://wealthyfy.ojpasoftware.com:8112/files/upload';

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

module.exports = {

    notification_list_API : async (request, response) => {

        const { tbl_user_id, pagesize, pagenumber } = request.body;

        // data_format is 2024-11-22;

        try {
            // Validate the user ID
            const userQueryResult = await pool.query( `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'`);
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.', });
            }
    
            // Fetch leaveResult records
            const leaveResult = await pool.query(`SELECT nt.*, u.tbl_office_id, u.emp_id, u.full_name, u.user_image, u.designation_abbr FROM tbl_notification nt INNER JOIN tbl_user u ON nt.tbl_user_id = u.tbl_user_id WHERE nt.parent_id = '${tbl_user_id}' order by tbl_notification_id DESC LIMIT ${pagesize} OFFSET (${pagenumber} - 1) * ${pagesize}`);
            
    
            if (leaveResult.rowCount > 0) {
                const leavData = leaveResult.rows.map((table) => {

                    return {
                        tbl_notification_id: table.tbl_notification_id,
                        tbl_user_id: table.tbl_user_id,
                        parent_id: table.parent_id,
                        emp_id: table.emp_id,
                        full_name: isNull(table.full_name),
                        user_image: isNull(base_img_url + '/user_image/' + table.user_image),
                        designation_abbr: isNull(table.designation_abbr),
                        tbl_office_id: table.tbl_office_id,
                        meeting_leave_id: table.meeting_leave_id,
                        title: isNull(table.title),
                        description: isNull(table.description),
                        notification_type: isNull(table.notification_type),                       
                        created_day: moment(table.created_date).utcOffset('+05:30').format('ddd'),
                        created_date: moment(table.created_date).utcOffset('+05:30').format('DD MMM, YYYY'),
                        created_time: moment(table.created_date).utcOffset('+05:30').format('h:mm:ss A'),
                        status: table.status
                        
                    };
                });
    
                return response.status(200).json({  status: true, message: 'User notification list.', data: leavData,});
            } else {
                return response.status(201).json({status: false, message: 'No User notification records found.', data: [], });
            }
        } catch (error) {
            console.error('Error fetching notification detail:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.', });
        }
    },


    


    

    


};