const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const nodeMailer = require('nodemailer')
const formidable = require('formidable');
const moment = require('moment');
const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);
const { base_img_url } = require('../wealthyfy_api_index');


function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


function isNUM(item) {
    if (item) {
        return item;
    } else {
        return 0;
    }
}


const createToken = (id) => {
    return jwt.sign({ id }, '2fbd467e26a1044dbc6e881fa2be61dc')
}

const transporter = nodeMailer.createTransport({
    host: 'smtp.gmail.com',
    port: 587,
    secure: false,
    auth: {
        user: 'aws.addcrypto@gmail.com',
        pass: 'tnafkiklxtbdsopq'
    }
});

module.exports = {

    user_team_designation_list_API: async(request, response) => {

        // console.log('user_team_designation_list_API');

        const { tbl_user_id  } = request.body;

        const userquery = await pool.query(`SELECT (SELECT reports_to FROM tbl_designation WHERE designation_abbr = tbl_user.designation_abbr), tbl_user_id, full_name, designation_abbr from tbl_user where tbl_user_id = '${tbl_user_id}'`);
        
        if(userquery.rowCount > 0){

            const reports_to = userquery.rows[0].reports_to;
            const full_name = userquery.rows[0].full_name;
            const user_designation = userquery.rows[0].designation_abbr;
            
            pool.query(`SELECT * FROM tbl_designation WHERE status = '1' AND reports_to > '${reports_to}'`, async (error, result) => {
                if (error) {
                    return response.status(403).json({ status: false, message: error });
                }

                if (result.rowCount > 0) {
                    var res = result.rows;
                    var data = [];

                    let cat = {
                        tbl_designation_id: "0",
                        designation_abbr: 'All',
                        designation_name: 'All',
                    };
                    data.push(cat);

                    res.forEach(function (table) {
                        let cat = {
                            tbl_designation_id: table.tbl_designation_id,
                            designation_abbr: isNull(table.designation_abbr),                    
                            designation_name: isNull(table.designation_name)                       
                        };
                        data.push(cat);
                    });
                    return  response.status(201).json({ status: true, message: 'User Team Designation list API', full_name : full_name, user_designation : user_designation, data: data })

                } else {
                    return response.status(201).json({ status: false, message: 'User Team Designation list API.', full_name : full_name, user_designation : user_designation, data: [] })
                }
            })
        }else{
            return response.status(201).json({ status: false, message: 'tbl_user_id is invalid.', full_name : '', user_designation:'', data: [] })
        }

    }, 

    user_login_api: (request, response) => {

        const { email, password, firebase_tokens } = request.body;
        console.log('user_login_api',  request.body);

        const lower_email = email.toLowerCase();


        pool.query(`SELECT tbl_user.*, (SELECT office_name FROM tbl_office WHERE tbl_office_id = tbl_user.tbl_office_id), 
            (SELECT designation_abbr FROM tbl_designation WHERE tbl_designation_id = tbl_user.tbl_designation_id),
            (SELECT designation_name FROM tbl_designation WHERE tbl_designation_id = tbl_user.tbl_designation_id) FROM tbl_user WHERE email = '${lower_email}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }

            var count = result.rowCount;

            if(count > 0) {

                //var enpassword =  encrypt(password);

                if (result.rows[0].password == password) {

                    var res = result.rows;
                    var data = [];

                    if (result.rows[0].status == 0) {

                       return response.status(201).json({ status: false, message: 'You are inactive user, Please contact to admin.', data: [] });

                    } else {
                        res.forEach(function (table){

                            let cat = {

                                tbl_user_id: table.tbl_user_id,
                                emp_id: table.emp_id,
                                tbl_office_id: isNull(table.tbl_office_id),
                                office_name: isNull(table.office_name),                                
                                designation_name: isNull(table.designation_name),
                                designation_type: isNull(table.designation_abbr),
                                full_name: isNull(table.full_name),
                                email: isNull(table.email),
                                mobile: isNull(table.mobile),
                                user_image: base_img_url + '/user_image/' + table.user_image,
                                jwt_token: isNull(table.jwt_token),
                                created_date: moment(table.created_date).utcOffset("+05:30").format('MMMM Do YYYY, h:mm:ss A'),
                            };
                            data.push(cat);
                        });

                        // update firebase token code start here

                        pool.query(`UPDATE tbl_user SET firebase_tokens = '${firebase_tokens}' WHERE tbl_user_id = '${result.rows[0].tbl_user_id}'`, (error, results) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                        })

                        // update firebase token code End here

                       return response.status(201).json({ status: true, message: 'Welcome To Wealthyfy' , data: data })
                    }
                } else {
                    return response.status(201).json({ status: false, message: 'The password you have entered is invalid', data: [] })
                }
            } else {
                return response.status(201).json({ status: false, message: 'You are not a registered user!.', data: [] })
            }
        })
    },

    my_profile_API: (request, response) => {

        const { tbl_user_id  } = request.body;

        const userquery = `SELECT u.*,  o.office_name, d.designation_abbr, d.designation_name, a.check_in_time AS check_in_status, 
            a.check_out_time AS check_out_status FROM tbl_user u
            LEFT JOIN tbl_office o ON o.tbl_office_id = u.tbl_office_id
            LEFT JOIN tbl_designation d ON d.tbl_designation_id = u.tbl_designation_id
            LEFT JOIN (SELECT tbl_user_id, tbl_office_id, MIN(check_in_time) AS check_in_time, MAX(check_out_time) AS check_out_time
            FROM tbl_attendance WHERE DATE(check_in_time) = CURRENT_DATE OR DATE(check_out_time) = CURRENT_DATE GROUP BY tbl_user_id, tbl_office_id) a ON a.tbl_user_id = u.tbl_user_id AND a.tbl_office_id = u.tbl_office_id 
            WHERE u.tbl_user_id = '${tbl_user_id}'`;

        // const userquery = `SELECT tbl_user.*, (SELECT office_name FROM tbl_office WHERE tbl_office_id = tbl_user.tbl_office_id), 
        // (SELECT designation_abbr FROM tbl_designation WHERE tbl_designation_id = tbl_user.tbl_designation_id),
        //     (SELECT check_in_time FROM tbl_attendance WHERE tbl_user_id = tbl_user.tbl_user_id AND tbl_office_id = tbl_user.tbl_office_id AND DATE(check_in_time) = CURRENT_DATE) as check_in_status,
        //     (SELECT check_out_time FROM tbl_attendance WHERE tbl_user_id = tbl_user.tbl_user_id AND tbl_office_id = tbl_user.tbl_office_id AND DATE(check_out_time) = CURRENT_DATE) as check_out_status,
        //     (SELECT designation_name FROM tbl_designation WHERE tbl_designation_id = tbl_user.tbl_designation_id) FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'`;

        pool.query(userquery, async(error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error });
            }

            if (result.rowCount > 0) {
                var res = result.rows;
                var data = [];

                res.forEach(function (table) {

                    const check_in_sts = table.check_in_status != null ? 'yes' : 'no';
                    const check_out_sts = table.check_out_status != null ? 'yes' : 'no';

                    if(table.designation_abbr == 'MD' || table.designation_abbr == 'VP' || table.designation_abbr == 'BM'){
                        Is_md_vp_bm = 'yes';
                    }else{
                        Is_md_vp_bm = 'no';
                    }
                    
                    let cat = {
                        tbl_user_id: table.tbl_user_id,
                        emp_id: table.emp_id,
                        tbl_office_id: isNull(table.tbl_office_id),
                        office_name: isNull(table.office_name),
                        designation_type: isNull(table.designation_abbr),
                        Is_md_vp_bm: isNull(Is_md_vp_bm),
                        designation_name: isNull(table.designation_name),
                        full_name: isNull(table.full_name),
                        email: isNull(table.email),
                        mobile: isNull(table.mobile),
                        check_in_status: isNull(check_in_sts),
                        check_out_status: isNull(check_out_sts),
                        user_image: base_img_url + '/user_image/' + table.user_image,
                        jwt_token: isNull(table.jwt_token),
                        created_date: moment(table.created_date).utcOffset("+05:30").format('MMMM Do YYYY, h:mm:ss A'),
                    };
                    data.push(cat);
                });
                return  response.status(201).json({ status: true, message: 'My profile API', data: data })

            } else {
                return response.status(201).json({ status: false, message: 'profile not found.', data: [] })
            }
        })
    },
    
    upload_profile_image : (request, response) => {

        const form = formidable ({ multiples: true});

        form.parse(request, async(err, fields, files)=>{

            if(err) {
                return response.status(201).json({ status: false, message: err, });
            }

            if(fields.tbl_user_id == undefined || fields.tbl_user_id == null || fields.tbl_user_id == '') {
                return response.status(201).json({ status: false, message: 'tbl_user_id is required', });
            }

            if(files.user_image == undefined || files.user_image == null || files.user_image == '') {
                return response.status(201).json({ status: false, message: 'user_image is required', });
            }

            const userquery = await pool.query(`SELECT tbl_user_id from tbl_user where tbl_user_id = '${fields.tbl_user_id}'`);

            if(userquery.rowCount > 0){


                const fileName = files.user_image.path;
                const filetype = files.user_image.type;
                const filecontent = fs.readFileSync(fileName);
                const type = filetype.split('/').pop();
                const imgname = Math.floor(10000000 + Math.random() * 90000000);
                const filenames = imgname + '.' + type;

                const path_dirctry = `./views/files/upload/user_image/${filenames}`;

                fs.writeFileSync(path_dirctry, filecontent, (err)=>{
                    if (err) {
                        console.error(err);
                    }
                });

                const Update_usr_img = await pool.query(`UPDATE tbl_user SET user_image = '${filenames}' where tbl_user_id = '${fields.tbl_user_id}'`);

                if (Update_usr_img.rowCount > 0) {
                    return response.status(201).json({ status: true, message: 'User image is uploded successfully' });
                } else {
                    return response.status(201).json({ status: false, message: 'User image failed to uplode' });
                }
            }else{
                return response.status(201).json({ status: false, message: 'user not found', });
            }
        });
        

    },

    my_team_API: async(request, response) => {

        const { tbl_user_id, designation_abbr  } = request.body;

        if (designation_abbr == '' || designation_abbr == null || designation_abbr == undefined) {
            var designation_abbr1 = ``
        } else {
            var designation_abbr1 = `AND u.designation_abbr = '${designation_abbr}'`;
        }

        // const userteamQuery = await pool.query(`SELECT tbl_user_id FROM tbl_user_connection WHERE tbl_user_id = $1 AND status = '1'`, [tbl_user_id]);
        
        const userteamQuery = await pool.query(`SELECT uc.tbl_user_id, u.full_name, u.designation_abbr  FROM tbl_user_connection uc INNER JOIN  tbl_user u ON uc.tbl_user_id = u.tbl_user_id WHERE uc.tbl_user_id = $1 AND uc.status = '1' limit 1`, [tbl_user_id]);

        if (userteamQuery.rowCount > 0) {

            const my_full_name = userteamQuery.rows[0].full_name;
            const my_designation = userteamQuery.rows[0].designation_abbr;

            
            ///////////// get team id code start from here ////////////////////////////////
            const recursivequery = `
                WITH RECURSIVE RecursiveCTE AS (
                SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_parent_id = $1

                UNION ALL

                SELECT t.tbl_user_id, t.tbl_parent_id 
                FROM tbl_user_connection t 
                INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `;
            const childUsersResult = await pool.query(recursivequery, [tbl_user_id]);
            userIds = childUsersResult.rows.map(row => row.tbl_user_id);

            ///////////// get team id code start from here ////////////////////////////////

            const userquery = `SELECT u.*,  o.office_name, d.designation_abbr, d.designation_name, a.check_in_time AS check_in_status, 
            a.check_out_time AS check_out_status FROM tbl_user u
            LEFT JOIN tbl_office o ON o.tbl_office_id = u.tbl_office_id
            LEFT JOIN tbl_designation d ON d.tbl_designation_id = u.tbl_designation_id
            LEFT JOIN (SELECT tbl_user_id, tbl_office_id, MIN(check_in_time) AS check_in_time, MAX(check_out_time) AS check_out_time
            FROM tbl_attendance WHERE DATE(check_in_time) = CURRENT_DATE OR DATE(check_out_time) = CURRENT_DATE GROUP BY tbl_user_id, tbl_office_id) a ON a.tbl_user_id = u.tbl_user_id AND a.tbl_office_id = u.tbl_office_id 
            WHERE u.tbl_user_id = ANY($1) ${designation_abbr1}
            ORDER BY CASE 
                    WHEN d.designation_abbr = 'AVP' THEN 1
                    WHEN d.designation_abbr = 'BM' THEN 2
                    WHEN d.designation_abbr = 'SRM' THEN 3
                    WHEN d.designation_abbr = 'EMP' THEN 4
                    ELSE 5
                END, 
            u.tbl_user_id DESC`;

            pool.query(userquery, [userIds], async(error, result) => {
                if (error) {
                    return response.status(403).json({ status: false, message: error });
                }

                if (result.rowCount > 0) {
                    var res = result.rows;
                    var data = [];

                    res.forEach(function (table) {

                        const check_in_sts = table.check_in_status != null ? 'yes' : 'no';
                        const check_out_sts = table.check_out_status != null ? 'yes' : 'no';
                        
                        let cat = {
                            tbl_user_id: table.tbl_user_id,
                            emp_id: table.emp_id,
                            tbl_office_id: isNull(table.tbl_office_id),
                            office_name: isNull(table.office_name),
                            designation_type: isNull(table.designation_abbr),
                            designation_name: isNull(table.designation_name),
                            full_name: isNull(table.full_name),
                            email: isNull(table.email),
                            mobile: isNull(table.mobile),
                            check_in_status: isNull(check_in_sts),
                            check_out_status: isNull(check_out_sts),
                            user_image: base_img_url + '/user_image/' + table.user_image,                          
                            created_date: moment(table.created_date).utcOffset("+05:30").format('MMMM Do YYYY'),
                            created_time: moment(table.created_date).utcOffset("+05:30").format('h:mm:ss A'),
                        };
                        data.push(cat);
                    });
                    return  response.status(201).json({ tbl_user_id : tbl_user_id, status: true, message: 'My Team API', my_full_name : my_full_name, my_designation : my_designation, data: data })

                } else {
                    return response.status(201).json({ tbl_user_id : tbl_user_id, status: false, message: 'Team not found.', my_full_name : my_full_name, my_designation : my_designation, data: [] })
                }
            })
        } else {
            // User not found or inactive
            return response.status(404).json({ status: false, message: 'tbl_user_id is not exist.' });
        }    
    },
};