// load the things we need
var express = require('express');
var cookieParser = require('cookie-parser');
var session = require('express-session');
var app = express();
var bodyParser = require('body-parser');
var axios = require('axios');
const expressLayout = require('express-ejs-layouts');
const moment_timezone = require('moment-timezone');
const moment = require('moment');
const path = require('path');
const pg = require('pg');
const formidable = require('formidable');
const dbConfig = require('../db');
const pool = new pg.Pool(dbConfig);
var apiurl = "http://wealthyfy.ojpasoftware.com:8112";
const  img_base_url = "http://wealthyfy.ojpasoftware.com:8112/files/upload";
const jwt = require('jsonwebtoken');
const { log } = require('console');
// use res.render to load up an ejs view file
app.use(express.static("views"));
app.use('/', express.static(path.join(__dirname, '/public')));
app.use('/:a', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b/:c', express.static(path.join(__dirname, '/public')));

app.use(expressLayout)
app.set('views', path.join(__dirname, 'templates/views'));
app.set('view engine', 'ejs');

// Latest version - v3.0.0
app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json({ limit: "150mb" }))

app.use(cookieParser());
app.use(session({ 
    secret: "Expense",
    cookie: { maxAge: 1000 * 60 * 60 * 24 * 7 },
    resave: true,
    saveUninitialized: true
}));

///////////////////////////// create token function  ///////////////////////
const createToken = (id) => {
    return jwt.sign({ id }, 'wlfy954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}
///////////////////////////// create token function  ///////////////////////

// Mock database for demonstration purposes
let userSessions = {}; // { userId: sessionId }

const auth = function (req, res, next) {
    if (req.session.supadminid) {
       // if(userSessions[req.session.supadminid] === req.session.id){
          next();
       // }else{
            // Session ID does not match, log the user out
            // req.session.destroy(() => {
            //     res.redirect('/');
            // });
       // }
    } else {
        // res.redirect('/');
        req.session.destroy(() => {
            res.redirect('/');
        });
    }
}

// Middleware to check if the user is not authenticated
const unauth = function (req, res, next) {
    if (req.session.supadminid && userSessions[req.session.supadminid] === req.session.id) {
        // If the user is authenticated, redirect them to another page (e.g., dashboard)
        res.redirect('/dashboard'); // Change '/dashboard' to whatever page you want to redirect to
    } else {
        // If not authenticated, allow access to the login page
        next();
    }
};


app.use(function (req, res, next) {
    var err = req.session.error;
    delete req.session.error;
    res.locals.imgbaseurl = img_base_url;
    res.locals.moment = moment;
    res.locals.moment_timezone = moment_timezone;
    res.locals.super_admin_id = req.session.supadminid;
    res.locals.user_name = req.session.username;
    res.locals.user_email = req.session.email;
    res.locals.user_pageno = req.session.user_list_page_no;
    res.locals.error = err;
    next();
});

app.get('/logout', function (req, res) {
    req.session.destroy(function () {
       res.redirect('/');
    });
})

app.get('/', unauth, function (req, res) {
    res.setHeader('Cache-Control', 'no-store');     // Prevent caching of the login page
    // res.setHeader('Pragma', 'no-cache');        // HTTP 1.0
    //res.setHeader('Expires', '0');              // Proxies

    res.render('login', {
        layout : false,
    });
});


// login page submit
app.post('/admin_login', function (req, res) {

    const { user_name, password } = req.body;

    pool.query(`SELECT * FROM tbl_admin WHERE  user_name = '${user_name}'`, async(error, result) => {
        if (error) {
            return response.status(201).json({ status: false, message: error.message, msg : "logi" })
        }
        var count = result.rowCount;
        if (count > 0) {

            if(result.rows[0].password == password)
            {

                const resdata = result.rows;

                const userId = resdata[0].tbl_admin_id;
                req.session.supadminid = userId;
                req.session.username = resdata[0].user_name;
                req.session.email = resdata[0].email;
                // Save the session ID to the database
                userSessions[userId] = req.session.id;
                
               res.redirect('/dashboard');
            }else{
                res.render('login', { layout: false, error : 'You Entered Wrong Password', });
            }
        }else{
            res.render('login', { layout: false, error : 'You Entered Wrong Details', });
        }
    })
});

app.get('/dashboard', auth, async(req, res)=> {
    const result = await pool.query(`
        SELECT (SELECT count(tbl_user_id) FROM tbl_user where status != 5) as total_user,
        (SELECT count(tbl_office_id) FROM tbl_office) as total_office,
        (SELECT count(tbl_attendance_id) FROM tbl_attendance ) as total_attendance,
        (SELECT count(tbl_meeting_id) FROM tbl_meeting) as total_meeting,
        (SELECT count(tbl_user_leave_id) FROM tbl_user_leave) as total_user_leave,
        (SELECT count(tbl_leave_type_id) FROM tbl_leave_type) as total_leave_type
    `);
    const admn_data = result.rows;

    res.render('dashboard', {
        layout : true,
        admn_data : admn_data,
        pagetitle: 'dashboard',
    });
});

///////////////////////////////////// Store Code start from here //////////////////////
app.get('/leave_type_list', auth,  async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_leave_type order by tbl_leave_type_id DESC`);
        const leav_typ_data = result.rows;

        res.render('leave_type_list', {
            layout: true,
            leav_typ_data: leav_typ_data,
            pagetitle: 'leavetyp_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/leave_type_details/:leav_type_id', auth, async(req,res)=>{
    try {
        const result = await pool.query(`SELECT * FROM tbl_leave_type where tbl_leave_type_id = '${req.params.leav_type_id}'`);
        const leav_typ_data = result.rows;

        res.render('leave_type_details',{
            layout : true,
            leav_typ_data: leav_typ_data,
            pagetitle: 'leavetyp_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
})

app.post('/update_leavetyp', auth, async (req, res) => {

    const { leave_type_id, leavetyp, status } = req.body;
    try {
        pool.query(`SELECT tbl_leave_type_id FROM tbl_leave_type where leave_type = '${leavetyp}' AND tbl_leave_type_id != '${leave_type_id}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {
                res.json({ status: false, message: 'Same leave type is already exist.'});                    
            } else {
                const result = await pool.query(`UPDATE tbl_leave_type SET leave_type = $$${leavetyp}$$,  status = '${status}' WHERE tbl_leave_type_id = '${leave_type_id}'`);

                if(result.rowCount > 0) {
                    res.json({ status: true, message: `leave type details is updated successfully.` });
                }else{
                    res.json({ status: false, message: 'Something wrong' });
                }
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
    }
});

app.get('/add_leave_type', auth, async(req,res)=>{
    try {
        res.render('add_leave_type',{
            layout : true,
            pagetitle: 'leavetyp_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/leave_type_add', auth, async (req, res) => {

    const { leavetyp } = req.body;
    try {
        pool.query(`SELECT tbl_leave_type_id FROM tbl_leave_type where leave_type = '${leavetyp}'`, async (error, result_res) => {
            if (error) { res.status(403).json({ status: false, message: error }) }
            if (result_res.rowCount > 0) {
                res.json({ status: false, message: 'Same leave type is already exist.'});                    
            } else {
                const result = await pool.query(`INSERT INTO tbl_leave_type (leave_type)values($$${leavetyp}$$)`);
                if(result.rowCount > 0) {
                    res.json({ status: true, message: `leave type is Added successfully.` });
                }else{
                    res.json({ status: false, message: 'Something wrong' });
                }
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
    }
});


///////////////////////////////////// Leave type list Code start from here /////////////////

app.get('/designation_list',  auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_designation order by reports_to ASC`);
        const desig_data = result.rows;

        res.render('designation_list', {
            layout: true,
            desig_data: desig_data,
            pagetitle: 'designation_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/designation_details/:desig_id', auth, async (req, res) => {

    const { desig_id } = req.params;
    try {
        const result = await pool.query(`SELECT * FROM tbl_designation where tbl_designation_id = '${desig_id}'`);
        const desig_data = result.rows;

        res.render('designation_details', {
            layout: true,
            desig_data: desig_data,
            pagetitle: 'designation_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/update_desig_name', auth,  async (req, res) => {

    const { tbl_design_id, designame } = req.body;

    const lower_designame = designame.toLowerCase();

    try {
        pool.query(`SELECT tbl_designation_id FROM tbl_designation where designation_name = '${lower_designame}' AND tbl_designation_id != '${tbl_design_id}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {
                res.json({ status: false, message: 'Same designation Name is already exist.'});                    
            } else {
                const result = await pool.query(`UPDATE tbl_designation SET designation_name = $$${lower_designame}$$ WHERE tbl_designation_id = '${tbl_design_id}'`);

                if(result.rowCount > 0) {
                    res.json({ status: true, message: `Designation Name is updated successfully.` });
                }else{
                    res.json({ status: false, message: 'Something wrong' });
                }
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
    }
});


///////////////////////////////////// all user leave code start from here ///////////////////////

app.get('/user_leave_list', auth, async (req, res) => {
    
    try {
        const result = await pool.query(`SELECT o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
            ul.* FROM tbl_user_leave ul 
            LEFT JOIN tbl_user u ON ul.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON ul.tbl_office_id = o. tbl_office_id 
            LEFT JOIN tbl_user ua ON ul.leave_approved_reject_by_user_id = ua.tbl_user_id 
            ORDER BY ul.tbl_user_leave_id DESC;`);
        const leave_data = result.rows;

        res.render('user_leave_list', {
            layout: true,
            leave_data: leave_data,
            pagetitle: 'leav_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/user_leave_detail/:user_leaveid', auth, async (req, res) => {

    const { user_leaveid } = req.params;

    try {
        const result = await pool.query(`SELECT o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
            ul.* FROM tbl_user_leave ul 
            LEFT JOIN tbl_user u ON ul.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON ul.tbl_office_id = o. tbl_office_id 
            LEFT JOIN tbl_user ua ON ul.leave_approved_reject_by_user_id = ua.tbl_user_id where tbl_user_leave_id = $1`, [user_leaveid]);
        const leave_data = result.rows;        

        res.render('user_leave_detail', {
            layout: true,
            leave_data: leave_data,
            pagetitle: 'leav_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/leave_status_update', auth, async (req, res) => {

    const { tbl_user_leave_id, status, leave_reject_reason } = req.body;

    if (leave_reject_reason == '' || leave_reject_reason == null || leave_reject_reason == undefined) {
        var reason1 = ''
    } else {
        var reason1 = leave_reject_reason;
    }
    try {
        pool.query(`SELECT * FROM tbl_user_leave where tbl_user_leave_id = '${tbl_user_leave_id}'`, async (error, result_res) => {
            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {

                if (result_res.rows[0].status == 'rejected' || result_res.rows[0].status == 'approved') {
                    return res.status(500).json({ status: false, message: `This leave is already ${result_res.rows[0].status}.`});

                } else {

                    const userQuery = await pool.query(`SELECT tbl_user_id, firebase_tokens as user_firebasetoken from tbl_user where tbl_user_id = '${result_res.rows[0].tbl_user_id}' AND status = '1'`);

                    /// update meeting details query

                    const updt_leav_query = `UPDATE tbl_user_leave SET status = '${status}', leave_approved_reject_by_user_id = '0',   leave_approved_reject_by_user_type = 'Admin', leave_approved_reject_date_time = now(), leave_rejected_reason = $$${reason1}$$ where tbl_user_leave_id = '${tbl_user_leave_id}'`;

                    try {
                        const leav_updtResult = await pool.query(updt_leav_query);
                        if (leav_updtResult.rowCount > 0) {

                            const title = `Leave is ${status}`;
                            const notification_type = 'leave'
                            const notification_message = `Your ${result_res.rows[0].leave_type} is ${status} by Admin`;
                            const firebase_token = userQuery.rows[0].user_firebasetoken;
                            const meeting_leave_id = tbl_user_leave_id;
                            const tbl_userid = '0';
                            const parent_id = result_res.rows[0].tbl_user_id;

                            // all_user_notification.send_notification_to_user_by_firebase_token(title, notification_message, notification_type, 'user', tbl_userid, firebase_token, meeting_leave_id, parent_id);
                            // console.log('notification data', title, notification_message, notification_type, 'user', tbl_userid, firebase_token, meeting_leave_id, parent_id);
                            

                            return res.status(201).json({ status: true, message: `Leave ${status} successfully.` });
                        } else {
                            return res.status(500).json({ status: false, message: 'Failed to update leave.' });
                        }
                    } catch (err) {
                        console.error(err);
                        return res.status(500).json({ status: false, message: 'Error occurred while updating leave.' });
                    }
                }
            } else {
                return res.status(201).json({ status: false, message: 'tbl_user_leave_id is wrong of this user.' });
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
    }
});


///////////////////////////////////// all user leave code end here ///////////////////////

///////////////////////////////////// user meeting code start from here ///////////////////////

// app.get('/user_meeting_list',  async (req, res) => {
//     try {
       

//         const result = await pool.query(`SELECT  o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
//             tm.*  FROM  tbl_meeting tm 
//             LEFT JOIN tbl_user u ON tm.tbl_user_id = u.tbl_user_id 
//             LEFT JOIN tbl_office o ON tm.tbl_office_id = o.tbl_office_id 
//             LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id 
//         ORDER BY tm.tbl_meeting_id DESC;`);

//         const meting_data = result.rows;

//         res.render('user_meeting_list', {
//             layout: true,
//             meting_data: meting_data,
//             pagetitle: 'meting_page'
//         });
//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });

app.get('/user_meeting_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`
            SELECT o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
                   tm.*  
            FROM tbl_meeting tm 
            LEFT JOIN tbl_user u ON tm.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON tm.tbl_office_id = o.tbl_office_id 
            LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id 
            ORDER BY tm.tbl_meeting_id DESC;
        `);

        const meting_data = result.rows;

        // Detect duplicate client_ids
        const clientIdCounts = {};
        meting_data.forEach(meeting => {
            const id = meeting.client_id;
            clientIdCounts[id] = (clientIdCounts[id] || 0) + 1;
        });

        // Mark duplicates
        const highlighted_meetings = meting_data.map(m => ({
            ...m,
            is_duplicate: clientIdCounts[m.client_id] > 1
        }));

        res.render('user_meeting_list', {
            layout: true,
            meting_data: highlighted_meetings,
            pagetitle: 'meting_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/meeting_detail/:meeting_id', auth, async (req, res) => {
    
    try {
        const { meeting_id } = req.params;

        const result = await pool.query(`SELECT  o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
            tm.*  FROM  tbl_meeting tm 
            LEFT JOIN tbl_user u ON tm.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON tm.tbl_office_id = o.tbl_office_id 
            LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id where tm.tbl_meeting_id = ${meeting_id};`);

        const meting_data = result.rows;

        res.render('user_meeting_detail', {
            layout: true,
            meting_data: meting_data,
            pagetitle: 'meting_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/update_meeting_status', auth, async (req, res) => {
    const { tbl_meeting_id, status, reject_meeting_reason } = req.body;

    // Handle rejection reason
    const reason = reject_meeting_reason ? reject_meeting_reason : '';

    try {
        // Fetch meeting details
        pool.query(`SELECT * FROM tbl_meeting WHERE tbl_meeting_id = '${tbl_meeting_id}'`, async (error, result_res) => {
            if (error) {
                return res.status(403).json({ status: false, message: error });
            }

            if (result_res.rowCount > 0) {
                const meeting = result_res.rows[0];

                // Prevent updating already finalized meetings
                if (meeting.meeting_status === 'rejected' || meeting.meeting_status === 'approved') {
                    return res.status(201).json({ status: false, message: `This meeting is already ${meeting.meeting_status}.` });
                }

                // Fetch user details
                const userQuery = await pool.query(`SELECT tbl_user_id, firebase_tokens AS user_firebasetoken FROM tbl_user WHERE tbl_user_id = '${meeting.tbl_user_id}' AND status = '1'`);

                // Update meeting status
                const update_meeting_query = `UPDATE tbl_meeting SET meeting_status = '${status}', approved_reject_by_user_type = 'Admin', 
                approved_reject_by_user_date = NOW(), reason = $$${reason}$$ WHERE tbl_meeting_id = '${tbl_meeting_id}'`;

                try {
                    const meetingUpdateResult = await pool.query(update_meeting_query);
                    if (meetingUpdateResult.rowCount > 0) {
                        // Prepare notification
                        const title = `Meeting is ${status}`;
                        const notification_type = 'meeting';
                        const notification_message = `Your meeting has been ${status} by Admin`;
                        const firebase_token = userQuery.rows[0]?.user_firebasetoken || '';
                        const meeting_id = tbl_meeting_id;
                        const tbl_userid = '0';
                        const parent_id = meeting.tbl_user_id;

                        // Send notification (if implemented)
                        // all_user_notification.send_notification_to_user_by_firebase_token(title, notification_message, notification_type, 'user', tbl_userid, firebase_token, meeting_id, parent_id);

                        return res.status(200).json({ status: true, message: `Meeting ${status} successfully.` });
                    } else {
                        return res.status(500).json({ status: false, message: 'Failed to update meeting status.' });
                    }
                } catch (err) {
                    console.error(err);
                    return res.status(500).json({ status: false, message: 'Error occurred while updating meeting.' });
                }
            } else {
                return res.status(404).json({ status: false, message: 'Invalid tbl_meeting_id.' });
            }
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        return res.status(500).json({ status: false, message: 'Server error. Please try again later.' });
    }
});

///////////////////////////////////// meeting code end here ///////////////////////

///////////////////////////////////// atendnce code start from here ///////////////////////

app.get('/atendance_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT o.office_name, u.full_name, u.designation_abbr, at.* FROM tbl_attendance at 
            LEFT JOIN tbl_user u ON at.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON o.tbl_office_id = at.tbl_office_id
            ORDER BY at.tbl_attendance_id DESC;
        `);

        const attendanceData = result.rows.map((table) => {
            // Parse check-in and check-out times
            const checkInTime = moment(table.check_in_time);
            const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

            // Calculate working time
            const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';

            return {
                tbl_attendance_id: table.tbl_attendance_id,
                tbl_user_id: table.tbl_user_id,
                office_name: table.office_name,
                full_name: table.full_name,
                designation_abbr: table.designation_abbr,
                // day_number: moment(table.created_date).format('DD'),
                // day_name: moment(table.created_date).format('ddd'),
                created_date: table.created_date,
                check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                working_time: workingTime,
            };
        });  

        res.render('user_atendence_list', {
            layout: true,
            attendance_data: attendanceData,
            pagetitle: 'atendnce_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/user_full_atendance_list/:tbl_user_id?', auth, async (req, res) => {
    try {
        const tbl_user_id = req.params.tbl_user_id || '41';

        // Fetch user & office info
        const userQueryResult = await pool.query(`SELECT u.full_name, u.created_date as user_created_date, u.designation_abbr, o.office_name 
            FROM tbl_user u LEFT JOIN tbl_office o ON o.tbl_office_id = u.tbl_office_id WHERE u.tbl_user_id = $1`,
            [tbl_user_id]);
        if (userQueryResult.rowCount === 0) {
            return res.status(404).send('User not found.');
        }

        const userInfo = userQueryResult.rows[0];

        const from_date = moment(userInfo.user_created_date).format('YYYY-MM-DD');
        // const from_date = req.query.from_date || moment().startOf('month').format('YYYY-MM-DD');
        const to_date = req.query.to_date || moment().format('YYYY-MM-DD');
        const status = req.query.status;
        console.log('tbl_user_id', tbl_user_id, 'from_date', from_date, 'to_date', to_date, 'status', status,);   
        
        
        const today = moment().format('YYYY-MM-DD');
        const safeToDate = moment(to_date).isAfter(today) ? today : to_date;        

        // Fetch attendance data
        const attendanceResult = await pool.query(
            `SELECT * FROM tbl_attendance WHERE tbl_user_id = $1 AND created_date BETWEEN $2 AND $3`,
            [tbl_user_id, from_date, safeToDate]
        );

        const presentDatesMap = {};
        attendanceResult.rows.forEach(row => {
            const dateStr = moment(row.created_date).format('YYYY-MM-DD');
            presentDatesMap[dateStr] = row;
        });

        // Fetch leave records
        const leaveResult = await pool.query(
            `SELECT from_date, to_date FROM tbl_user_leave WHERE tbl_user_id = $1 AND from_date <= $2 AND to_date >= $3`,
            [tbl_user_id, safeToDate, from_date]
        );

        const leaveDatesSet = new Set();
        leaveResult.rows.forEach(leave => {
            const start = moment(leave.from_date);
            const end = moment(leave.to_date);
            for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                leaveDatesSet.add(m.format('YYYY-MM-DD'));
            }
        });

        // Final data list
        const start = moment(from_date);
        const end = moment(safeToDate);
        const fullAttendanceList = [];

        for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
            const currentDateStr = m.format('YYYY-MM-DD');
            const dayOfWeek = m.day();
            const presentRow = presentDatesMap[currentDateStr];
            let isLate = 'no';

            if (presentRow) {
                const checkInTime = moment(presentRow.check_in_time);
                const checkOutTime = presentRow.check_out_time ? moment(presentRow.check_out_time) : null;
                const workingTime = checkOutTime
                    ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s`
                    : 'N/A';

                const officeLateTime = '08:45';
                const [lateHour, lateMinute] = officeLateTime.split(':').map(Number);
                const lateThreshold = moment(checkInTime).startOf('day').hour(lateHour).minute(lateMinute);
                isLate = checkInTime.isAfter(lateThreshold) ? 'yes' : 'no';

                fullAttendanceList.push({
                    tbl_attendance_id: presentRow.tbl_attendance_id,
                    tbl_user_id: presentRow.tbl_user_id,
                    office_name: userInfo.office_name,
                    full_name: userInfo.full_name,
                    designation_abbr: userInfo.designation_abbr,
                    created_date: m.format('MMM Do ddd YYYY'),
                    check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                    check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                    working_time: workingTime,
                    isLate: isLate,
                    status: 'present'
                });

            } else if (leaveDatesSet.has(currentDateStr)) {
                fullAttendanceList.push({
                    tbl_attendance_id: 0,
                    tbl_user_id,
                    office_name: userInfo.office_name,
                    full_name: userInfo.full_name,
                    designation_abbr: userInfo.designation_abbr,
                    created_date: m.format('MMM Do ddd YYYY'),
                    check_in_time: 'N/A',
                    check_out_time: 'N/A',
                    working_time: 'N/A',
                    isLate: 'no',
                    status: 'leave'
                });
            } else {
                const isWeekend = dayOfWeek === 0 || dayOfWeek === 6;
                fullAttendanceList.push({
                    tbl_attendance_id: 0,
                    tbl_user_id,
                    office_name: userInfo.office_name,
                    full_name: userInfo.full_name,
                    designation_abbr: userInfo.designation_abbr,
                    created_date: m.format('MMM Do ddd YYYY'),
                    check_in_time: 'N/A',
                    check_out_time: 'N/A',
                    working_time: 'N/A',
                    isLate: 'no',
                    status: isWeekend ? 'off' : 'absent'
                });
            }
        }

        const filteredList = status ? fullAttendanceList.filter(item => item.status === status) : fullAttendanceList;

        // console.log('filteredList', filteredList);
        

        res.render('user_full_atendance_list', {
            layout: true,
            fullattendancedata: filteredList,
            pagetitle: 'Attendance Page',
            user_info: userInfo
        });

    } catch (error) {
        console.error('Error fetching attendance list:', error);
        res.status(500).send('Error occurred while fetching attendance.');
    }
});


///////////////////////////////////// atendnce code end here ///////////////////////

/////////////////////////   wealthyfy code start from here   /////////////////// 

///////////////////////////////////// admin Code start from here //////////////////////


app.get('/user_list', auth, async (req, res) => {

    try {
        const result = await pool.query(`SELECT (SELECT office_name FROM tbl_office where tbl_office_id = tbl_user.tbl_office_id), tbl_user.* FROM tbl_user where status != 5 order by tbl_user_id DESC`);
        const usr_data = result.rows;
        
        res.render('user_list', {
            layout: true,
            usr_data: usr_data,
            pagetitle: 'user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/edit_user/:user_id', auth, async (req, res) => {
    try {
    
        const result = await pool.query(`SELECT * FROM tbl_user where tbl_user_id = '${req.params.user_id}' AND status != 5`);
        const user_data = result.rows;

        const designation_query = await pool.query(`SELECT * FROM tbl_designation where status = 1 order by reports_to ASC`);
        const designtion_data = designation_query.rows;

        const office_query = await pool.query(`SELECT * FROM tbl_office where status = 1 order by tbl_office_id ASC`);
        const office_data = office_query.rows;       
            
        res.render('user_detail', {
            layout : true,
            user_data : user_data,
            designtion_data : designtion_data,
            office_data : office_data,
            pagetitle : 'user_page'
        });
       
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/view_user_detail/:user_id/:pageurl?',  async (req, res) => {
    try {
        const userId = req.params.user_id;

        // Initiate queries
        const [storePromise, meetingRes, leavRes] = [
            pool.query(`SELECT 
                (SELECT office_name FROM tbl_office WHERE tbl_office_id = tbl_user.tbl_office_id) AS office_name,
                full_name, created_date AS user_created_date, designation_abbr, *
                FROM tbl_user WHERE tbl_user_id = $1 AND status != 5`, [userId]),

            pool.query(`SELECT ua.full_name AS approved_by_user_name, tm.*  
                        FROM tbl_meeting tm 
                        LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id 
                        WHERE tm.tbl_user_id = $1`, [userId]),

            pool.query(`SELECT ua.full_name AS approved_by_user_name, ul.* 
                        FROM tbl_user_leave ul 
                        LEFT JOIN tbl_user ua ON ul.leave_approved_reject_by_user_id = ua.tbl_user_id 
                        WHERE ul.tbl_user_id = $1`, [userId])
        ];

        const [userResult, meetingResult, leaveResult] = await Promise.all([storePromise, meetingRes, leavRes]);

        if (userResult.rowCount === 0) return res.redirect('/error_page');
        
        const user = userResult.rows[0];

        // Dates
        const from_date = moment(user.user_created_date).format('YYYY-MM-DD');
        const to_date = moment().format('YYYY-MM-DD');
        const safeToDate = moment(to_date).isAfter(moment()) ? moment().format('YYYY-MM-DD') : to_date;

        console.log('from_date', from_date);
        console.log('safeToDate', safeToDate);
        

        // Fetch attendance data
        const attendanceResult = await pool.query(
            `SELECT * FROM tbl_attendance WHERE tbl_user_id = $1 AND created_date BETWEEN $2 AND $3`,
            [userId, from_date, safeToDate]
        );

        // Map present days
        const presentDatesMap = {};
        attendanceResult.rows.forEach(row => {
            const dateStr = moment(row.created_date).format('YYYY-MM-DD');
            presentDatesMap[dateStr] = row;
        });

        // Get leave range days
        const leaveDatesSet = new Set();
        leaveResult.rows.forEach(leave => {
            const start = moment(leave.from_date);
            const end = moment(leave.to_date);
            for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                leaveDatesSet.add(m.format('YYYY-MM-DD'));
            }
        });

        // Prepare final attendance data
        const start = moment(from_date);
        const end = moment(safeToDate);
        const fullAttendanceList = [];

        for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
            const currentDateStr = m.format('YYYY-MM-DD');
            const dayOfWeek = m.day();
            const presentRow = presentDatesMap[currentDateStr];
            let isLate = 'no';
            let isEarly = 'no';
            
            if (presentRow) {
                const checkInTime = moment(presentRow.check_in_time);
                const checkOutTime = presentRow.check_out_time ? moment(presentRow.check_out_time) : null;
                const workingTime = checkOutTime
                    ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s`
                    : 'N/A';

                ///// office late code start from here
                    // Extract hours and minutes from check-in time
                        const checkInHour = checkInTime.hour();
                        const checkInMinute = checkInTime.minute();

                        // Convert both times to minutes for easy comparison
                        const checkInTotalMinutes = checkInHour * 60 + checkInMinute;
                        const officeLateTotalMinutes = 8 * 60 + 45; // 08:45 AM

                        const isLate = checkInTotalMinutes > officeLateTotalMinutes ? 'late' : 'no';

                        // console.log('Check-in Time:', checkInTime.format('HH:mm'));
                        // console.log('isLate:', isLate);

                    
                ///// office late code end here
                
                ///// office early code start from here
                    const officeEarlyTime = '07:00';        // Start of early range
                    const officeEarlyEndTime = '08:28';     // End of early range
                    
                    const [earlyHour, earlyMinute] = officeEarlyTime.split(':').map(Number);
                    const [earlyEndHour, earlyEndMinute] = officeEarlyEndTime.split(':').map(Number);
                    
                    // Create Moment.js time ranges
                    const earlyStart = moment(checkInTime).startOf('day').hour(earlyHour).minute(earlyMinute);
                    const earlyEnd = moment(checkInTime).startOf('day').hour(earlyEndHour).minute(earlyEndMinute);
                    console.log('checkInTime', checkInTime);
                    
                    // Check if current check-in is early
                    isEarly = checkInTime.isBetween(earlyStart, earlyEnd, null, '[)') ? 'early' : 'no';

                    //console.log('isEarly', isEarly);
                    

                    // console.log('isEarly', isEarly);
                ///// office early code end here

                fullAttendanceList.push({
                    tbl_attendance_id: presentRow.tbl_attendance_id,
                    tbl_user_id: presentRow.tbl_user_id,
                    office_name: user.office_name,
                    full_name: user.full_name,
                    designation_abbr: user.designation_abbr,
                    created_date: m.format('MMM Do ddd YYYY'),
                    check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                    check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                    working_time: workingTime,
                    isLate: presentRow.is_late,
                    isEarly: presentRow.is_early,
                    status: 'present'
                });

            } else if (leaveDatesSet.has(currentDateStr)) {
                fullAttendanceList.push({
                    tbl_attendance_id: 0,
                    tbl_user_id: userId,
                    office_name: user.office_name,
                    full_name: user.full_name,
                    designation_abbr: user.designation_abbr,
                    created_date: m.format('MMM Do ddd YYYY'),
                    check_in_time: 'N/A',
                    check_out_time: 'N/A',
                    working_time: 'N/A',
                    isLate: 'no',
                    isEarly: 'no',
                    status: 'leave'
                });
            } else {
                const isWeekend = dayOfWeek === 0 || dayOfWeek === 6;
                fullAttendanceList.push({
                    tbl_attendance_id: 0,
                    tbl_user_id: userId,
                    office_name: user.office_name,
                    full_name: user.full_name,
                    designation_abbr: user.designation_abbr,
                    created_date: m.format('MMM Do ddd YYYY'),
                    check_in_time: 'N/A',
                    check_out_time: 'N/A',
                    working_time: 'N/A',
                    isLate: 'no',
                    isEarly: 'no',
                    status: isWeekend ? 'off' : 'absent'
                });
            }
        }

        // Detect duplicate client_ids in meetings
        const meting_data = meetingResult.rows;
        const clientIdCounts = {};
        meting_data.forEach(meeting => {
            const id = meeting.client_id;
            clientIdCounts[id] = (clientIdCounts[id] || 0) + 1;
        });

        const highlighted_meetings = meting_data.map(m => ({
            ...m,
            is_duplicate: clientIdCounts[m.client_id] > 1
        }));

        

        res.render('view_user', {
            layout: true,
            pageurl: req.params.pageurl,
            user_data: [user],
            meting_data: highlighted_meetings,
            leave_data: leaveResult.rows,
            attendance_data: fullAttendanceList,
            pagetitle: 'user_page'
        });

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


// app.get('/view_user_detail/:user_id/:pageurl?',  async (req, res) => {
//     try {
//         const userId = req.params.user_id;
        
//         // Initiate all queries concurrently
//         const [storePromise, meetingRes,  leavRes, atendencRes] = [
//             pool.query(`SELECT (SELECT office_name FROM tbl_office where tbl_office_id = tbl_user.tbl_office_id), tbl_user.* FROM tbl_user where tbl_user_id = '${userId}' AND status != 5`),

//             pool.query(`SELECT ua.full_name AS approved_by_user_name, tm.*  FROM  tbl_meeting tm LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id where tm.tbl_user_id = '${userId}'`),

//             pool.query(`SELECT ua.full_name AS approved_by_user_name, ul.* FROM tbl_user_leave ul LEFT JOIN tbl_user ua ON ul.leave_approved_reject_by_user_id = ua.tbl_user_id where ul.tbl_user_id = $1`, [userId]),

//             pool.query(`SELECT * FROM tbl_attendance WHERE tbl_user_id = '${userId}' ORDER BY tbl_attendance_id DESC`)
            
//         ];
//         // Wait for all promises to resolve
//         const [result, meetingResult, leavResult, atendencResult ] = await Promise.all([storePromise, meetingRes, leavRes, atendencRes]);

//         if(result.rowCount > 0){

//             const attendanceData = atendencResult.rows.map((table) => {
//                 // Parse check-in and check-out times
//                 const checkInTime = moment(table.check_in_time);
//                 const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

//                 // Calculate working time
//                 const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';

//                 return {
//                     tbl_attendance_id: table.tbl_attendance_id,
//                     tbl_user_id: table.tbl_user_id,                    
//                     // day_number: moment(table.created_date).format('DD'),
//                     // day_name: moment(table.created_date).format('ddd'),
//                     created_date: table.created_date,
//                     check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
//                     check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
//                     working_time: workingTime,
//                 };
//             });   
            
//             const meting_data = meetingResult.rows;

//             // Detect duplicate client_ids
//             const clientIdCounts = {};
//             meting_data.forEach(meeting => {
//                 const id = meeting.client_id;
//                 clientIdCounts[id] = (clientIdCounts[id] || 0) + 1;
//             });
    
//             // Mark duplicates
//             const highlighted_meetings = meting_data.map(m => ({
//                 ...m,
//                 is_duplicate: clientIdCounts[m.client_id] > 1
//             }));

//             res.render('view_user', {
//                 layout: true,
//                 pageurl: req.params.pageurl,
//                 user_data: result.rows,
//                 meting_data: highlighted_meetings,
//                 leave_data: leavResult.rows,
//                 attendance_data: attendanceData,
//                 pagetitle: 'user_page'
//             });
//         }else{
//             res.redirect('/error_page');
//         }

//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });


app.post('/user_update', auth, function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();

     
        const dgnation_data = fields.designation_data.toString().split(',');
        const designation_id = dgnation_data[0];
        const designation_abbr = dgnation_data[1];

        data.append('tbl_user_id', fields.tbl_user_id);
        data.append('emp_id', fields.user_empId);
        data.append('tbl_designation_id', designation_id);
        data.append('designation_abbr', designation_abbr);
        data.append('tbl_office_id', fields.office_id);
        data.append('email', fields.email);
        data.append('full_name', fields.full_name);
        data.append('mobile', fields.mobile);
        data.append('password', fields.pswd);
        data.append('user_latitude', fields.user_lat);
        data.append('user_longitude', fields.user_long);
        data.append('user_city', fields.city);
        data.append('user_state', fields.state);
        data.append('status', fields.status);
        data.append('user_area', fields.area);
        data.append('user_full_addrss', fields.user_full_addrss);
        
        if(files.user_image != undefined){
            if (files.user_image.size > 0) {
                data.append('user_image', fs.createReadStream(files.user_image.path));
               const userextnxn_typ =  files.user_image.type.split('/').pop();  
                if (["png", "jpg", "jpeg"].includes(userextnxn_typ)) {
                    data.append('user_image_extn', userextnxn_typ);
                } else {
                    return res.status(201).json({ status: false, message: "Please select a valid image (PNG, JPG, JPEG).", });
                }
            } else {
                console.log('user_image nhi hai');
            } 
        }else{
            console.log('user_image files is undefined');
        }


        var config = {
            method: 'post',
            url: apiurl +  '/admin_user_data/update_user_details_API',
            headers: {
                // 'Authorization': 'Bearer ' + req.session.token,
                ...data.getHeaders()
            },
            data: data
        };        

        axios(config)
        .then((user_updt_res) => {
           

            var sts = user_updt_res.data.status;
            var msg = user_updt_res.data.message;
            
            if (sts == false) {
                res.status(201).json({ status: false, message: msg, });
            } else {
                res.status(201).json({ status: true, message: msg, });
            }
        })
        .catch(function (error) {
            console.log(error);
        });
    });
});

app.get('/add_user', auth, async (req, res) => {

    const designation_query = await pool.query(`SELECT * FROM tbl_designation where status = 1 order by reports_to ASC`);
    const designtion_data = designation_query.rows;

    const office_query = await pool.query(`SELECT * FROM tbl_office where status = 1 order by tbl_office_id ASC`);
    const office_data = office_query.rows;

    try {
        res.render('add_user', {
            designtion_data : designtion_data,
            office_data : office_data,
            layout: true,
            pagetitle : 'user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/user_add', auth, function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();

     
        const dgnation_data = fields.designation_data.toString().split(',');
        const designation_id = dgnation_data[0];
        const designation_abbr = dgnation_data[1];
  
        data.append('emp_id', fields.user_empId);
        data.append('tbl_designation_id', designation_id);
        data.append('designation_abbr', designation_abbr);
        data.append('tbl_office_id', fields.office_id);
        data.append('email', fields.email);
        data.append('full_name', fields.full_name);
        data.append('mobile', fields.mobile);
        data.append('password', fields.pswd);
        data.append('user_latitude', fields.user_lat);
        data.append('user_longitude', fields.user_long);
        data.append('user_city', fields.city);
        data.append('user_state', fields.state);
        data.append('user_area', fields.area);
        data.append('user_full_addrss', fields.user_full_addrss);
        
        if(files.user_image != undefined){
            if (files.user_image.size > 0) {
                data.append('user_image', fs.createReadStream(files.user_image.path));
               const userextnxn_typ =  files.user_image.type.split('/').pop();  
                if (["png", "jpg", "jpeg"].includes(userextnxn_typ)) {
                    data.append('user_image_extn', userextnxn_typ);
                } else {
                    return res.status(201).json({ status: false, message: "Please select a valid image (PNG, JPG, JPEG).", });
                }
            } else {
                console.log('user_image nhi hai');
            } 
        }else{
            console.log('user_image files is undefined');
        }


        var config = {
            method: 'post',
            url: apiurl +  '/admin_user_data/create_user_by_admin_API',
            headers: {
                // 'Authorization': 'Bearer ' + req.session.token,
                ...data.getHeaders()
            },
            data: data
        };        

        axios(config)
        .then((user_add_res) => {
          

            var sts = user_add_res.data.status;
            var msg = user_add_res.data.message;
            
            if (sts == false) {
                res.status(201).json({ status: false, message: msg, });
            } else {
                res.status(201).json({ status: true, message: msg, });
            }
        })
        .catch(function (error) {
            console.log(error);
        });
    });
});

// app.post('/user_add', async (req, res) => {

//     const {  designation_data, office_id, full_name, mobile, pswd, email } = req.body;
//     const full_name_capital = full_name.toLowerCase();

//     const dgnation_data = designation_data.toString().split(',');
//     const designation_id = dgnation_data[0];
//     const designation_abbr = dgnation_data[1];

//     // const check_username = await pool.query(`SELECT tbl_admin_id, user_name FROM tbl_admin where user_name = '${user_name_capital}'`);
//     // if (check_username.rowCount > 0) {
//     //     return (res.status(201).json({ status: false, message: 'Same user name is already exist.'}))
//     // }

//     const check_email = await pool.query(`SELECT tbl_user_id FROM tbl_user where email = '${email}'`);
//     if (check_email.rowCount > 0) {
//         return (res.status(201).json({ status: false, message: 'Same email is already exist.' }))
//     }

//     try {
//         pool.query(`SELECT mobile FROM tbl_user where mobile = '${mobile}' `, async (error, result_res) => {
//             if (error) { res.status(403).json({ status: false, message: error }) }

//             if (result_res.rowCount > 0) {
//                 res.json({ status: false, message: 'Same mobile is already exist.' });
//             } else {   

//                 const result = await pool.query(`INSERT INTO tbl_user(full_name, email, firebase_tokens, user_image, password, tbl_designation_id, tbl_office_id, mobile, designation_abbr)VALUES('${full_name_capital}', '${email}', 'default_user_image.jpeg', 'firebase_tokens', $$${pswd}$$, '${designation_id}', '${office_id}', '${mobile}', '${designation_abbr}') returning tbl_user_id`);

//                 if (result.rowCount > 0) {

//                     const token = createToken(result.rows[0].tbl_user_id);               
//                     const generate_jwttoken_id = await pool.query(`UPDATE tbl_user SET jwt_token ='${token}' WHERE tbl_user_id = '${result.rows[0].tbl_user_id}'`);

//                     res.json({ status: true, message: `User created successfully.` });
//                 } else {
//                     res.json({ status: false, message: 'Something wrong' });
//                 }
//             }
//         })
//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });

///////////////////////////////////// User Code end here //////////////////////

///////////////////////////////////// Office start from here //////////////////////

app.get('/office_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_office order by tbl_office_id DESC`);
        const ofic_data = result.rows;
        res.render('office_list', {
            layout: true,
            ofic_data: ofic_data,
            pagetitle: 'ofic_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/office_details/:offic_id', auth, async (req, res) => {

    try {
        const { offic_id } = req.params;
    
        const result = await pool.query(`SELECT * FROM tbl_office where tbl_office_id = '${offic_id}'`);
        const ofic_data = result.rows;
        
        res.render('office_detail', {
            layout: true,
            ofice_data: ofic_data,
            pagetitle: 'ofic_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/office_map/:offic_id?', auth, async (req, res) => {

    try {
        // const { offic_id } = req.params;
        const offic_id = req.params.offic_id != undefined ? req.params.offic_id : '32';
        // console.log('offic_id', offic_id);
        
        const result = await pool.query(`SELECT * FROM tbl_office where tbl_office_id = '${offic_id}'`);
        const ofic_data = result.rows;
        
        res.render('office_map_detail', {
            layout: true,
            ofice_data: ofic_data,
            pagetitle: 'ofic_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/office_map_add', auth, async (req, res) => {
    try {        
        res.render('office_map_add', {
            layout: true,           
            pagetitle: 'ofic_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/office_update', auth, async (req, res) => {
    const { office_id, full_name, email, mobile, area, city, state, status, office_addrss, ofice_lat, ofice_long } = req.body;

    const full_name_lower = full_name.toLowerCase();

    if(area == '' || area == null || area == undefined){
        var area1 = ''
    }else{
        var area1 = area;
    }

    try {
        // Combined query to check duplicates in a single call
        const duplicateCheckQuery = `
            SELECT 
                COUNT(*) FILTER (WHERE LOWER(office_name) = $1 AND tbl_office_id != $2) AS name_exists,
                COUNT(*) FILTER (WHERE office_email = $3 AND tbl_office_id != $2) AS email_exists,
                COUNT(*) FILTER (WHERE office_phone = $4 AND tbl_office_id != $2) AS mobile_exists
            FROM tbl_office;
        `;

        const duplicateCheckResult = await pool.query(duplicateCheckQuery, [full_name_lower, office_id, email, mobile]);
        const { name_exists, email_exists, mobile_exists } = duplicateCheckResult.rows[0];

        if (name_exists > 0) {
            return res.status(201).json({ status: false, message: 'Office name already exists.' });
        }
        if (email_exists > 0) {
            return res.status(201).json({ status: false, message: 'Same email already exists.' });
        }
        if (mobile_exists > 0) {
            return res.status(201).json({ status: false, message: 'Same mobile number already exists.' });
        }

        // Update office details
        const updateQuery = `UPDATE tbl_office SET office_name = $1, office_email = $2, office_phone = $3, office_city = $4, office_state = $5, status = $6, office_address = $7, office_latitude = $8, office_longitude = $9, area =$10 WHERE tbl_office_id = $11`;
        const result = await pool.query(updateQuery, [
            full_name_lower, email, mobile, city, state, status, office_addrss, ofice_lat, ofice_long, area1, office_id
        ]);

        if (result.rowCount > 0) {
            res.json({ status: true, message: 'Office details updated successfully.' });
        } else {
            res.json({ status: false, message: 'No changes were made to the office details.' });
        }

    } catch (error) {
        console.error('Error updating office data:', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

app.get('/add_office', auth, async (req, res) => {
    try {        
        res.render('add_office', {
            layout: true,           
            pagetitle: 'ofic_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/office_add', auth, async (req, res) => {  

    const { full_name, email, mobile,area, city, state, office_addrss, ofice_lat, ofice_long } = req.body;

    const full_name_lower = full_name.toLowerCase();
    const email_lower = email.toLowerCase();
    if(area == '' || area == null || area == undefined){
        var area1 = ''
    }else{
        var area1 = area;
    }

    try {
        // Check for existing office details
        const duplicateCheckQuery = `
            SELECT 
                COUNT(*) FILTER (WHERE LOWER(office_name) = $1) AS name_exists,
                COUNT(*) FILTER (WHERE office_email = $2) AS email_exists,
                COUNT(*) FILTER (WHERE office_phone = $3) AS mobile_exists
            FROM tbl_office;
        `;

        const duplicateCheckResult = await pool.query(duplicateCheckQuery, [full_name_lower, email_lower, mobile]);
        const { name_exists, email_exists, mobile_exists } = duplicateCheckResult.rows[0];

        if (name_exists > 0) {
            return res.status(201).json({ status: false, message: 'Office name already exists.' });
        }
        if (email_exists > 0) {
            return res.status(201).json({ status: false, message: 'Same email already exists.' });
        }
        if (mobile_exists > 0) {
            return res.status(201).json({ status: false, message: 'Same mobile number already exists.' });
        }

        // Insert new office details
        const insertQuery = `INSERT INTO tbl_office (office_name, office_email, office_phone, office_city, office_state, office_address, office_latitude, office_longitude,area) VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)`;

        const result = await pool.query(insertQuery, [
            full_name_lower, email_lower, mobile, city, state, office_addrss, ofice_lat, ofice_long, area1
        ]);

        if (result.rowCount > 0) {            
            res.json({ status: true, message: 'New Office details added successfully.' });
        } else {
            res.json({ status: false, message: 'Failed to add office details.' });
        }

    } catch (error) {
        console.error('Error adding office data:', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

///////////////////////////////////// Office code end here //////////////////////

app.get('/md_user_list', auth,  async (req, res) => {

    try {
        const result = await pool.query(`SELECT  * FROM tbl_user where status != 5 AND designation_abbr = 'MD' order by tbl_user_id DESC`);
        const mdusr_data = result.rows;
        
        res.render('md_user_list', {
            layout: true,
            usr_data: mdusr_data,
            pagetitle: 'md_user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/md_assign_vp_list/:md_user_id', auth,  async (req, res) => {

    const { md_user_id } = req.params;

    try {
        const result = await pool.query(`SELECT (SELECT full_name FROM tbl_user where tbl_user_id = $1 AND designation_abbr = 'MD') as md_fullname, u.*, ucn.* FROM tbl_user u INNER JOIN tbl_user_connection ucn ON u.tbl_user_id = ucn.tbl_user_id where ucn.tbl_parent_id = $1 AND u.status != 5 AND u.designation_abbr = 'VP' order by ucn.tbl_user_id DESC`, [md_user_id]);
        const mdvpusr_data = result.rows;
        
        res.render('md_assign_vp_list', {
            layout: true,
            md_user_id: md_user_id,
            mdvplist_data: mdvpusr_data,
            pagetitle: 'md_user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/md_assign_new_vp/:md_user_id',  auth, async (req, res) => {
    const { md_user_id } = req.params;
    try {
        const [mdPromis, vplistquery] = [
            pool.query(`SELECT full_name as md_name, mobile FROM tbl_user where tbl_user_id = '${md_user_id}' AND designation_abbr = 'MD'`),
            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'VP' AND NOT EXISTS (
            SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`)
        ]
        const [mdusr_data, vplistdata] = await Promise.all([mdPromis, vplistquery]);        

        res.render('md_assign_new_vp', {
            layout: true,
            md_user_id: md_user_id,
            md_data: mdusr_data.rows,
            vplist_data: vplistdata.rows,
            pagetitle: 'md_user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/md_assign_vp_add', auth, async (req, res) => {
    const { md_userid, vp_user_id } = req.body;

    try {
        // Check if vp_user_id exists in tbl_user
        const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
        const userCheckResult = await pool.query(userCheckQuery, [vp_user_id]);

        if (userCheckResult.rows[0].user_exists == 0) {
            return res.status(201).json({ status: false, message: 'VP User ID not found.' });
        }

        // Check if VP is already assigned in tbl_user_connection
        const assignedCheckQuery = `SELECT COUNT(*) AS assigned FROM tbl_user_connection WHERE tbl_user_id = $1`;
        const assignedCheckResult = await pool.query(assignedCheckQuery, [vp_user_id]);

        if (assignedCheckResult.rows[0].assigned > 0) {
            return res.status(200).json({ status: false, message: 'VP is already assigned to an MD.' });
        }
     
        const insertResult = await pool.query(`INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id)VALUES ($1, $2)`, [vp_user_id, md_userid]);

        if (insertResult.rowCount > 0) {
            res.json({ status: true, message: 'VP assigned to MD successfully.' });
        } else {
            res.json({ status: false, message: 'Failed to assign VP to MD.' });
        }

    } catch (error) {
        console.error('Error assigning VP to MD:', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

////////////////////////////////// md create team code start from here //////////////////
app.get('/md_create_team/:md_user_id', auth, async (req, res) => {
    const { md_user_id } = req.params;

    try {
        // Fetch all required data concurrently using Promise.all
        const [mdusr_data, vplistdata, avplistdata, mdvpusr_data, bmlistdata, childUsersResult, srmlistResult, rmlistResult, EMPlistResult ] = await Promise.all([
            pool.query(`SELECT full_name as md_name, mobile FROM tbl_user WHERE tbl_user_id = $1 AND designation_abbr = 'MD'`, [md_user_id]),

            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'VP' AND NOT EXISTS (
                SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'AVP' AND NOT EXISTS (
                SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`SELECT u.tbl_user_id, u.full_name, ucn.* FROM tbl_user u INNER JOIN tbl_user_connection ucn ON u.tbl_user_id = ucn.tbl_user_id WHERE ucn.tbl_parent_id = $1 AND u.status != 5 AND u.designation_abbr = 'VP' ORDER BY ucn.tbl_user_id DESC`, [md_user_id]),
            
            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'BM' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `, [md_user_id]),
            
            //// free for assign srm list
            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'SRM' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'RM' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            //// free for assign EMP list
            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'EMP' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

        ]);

        // Extract user IDs from the recursive query result
        const userIds = childUsersResult.rows.map(row => row.tbl_user_id);        

        // Fetch BM data based on userIds
        const mdavpusr_data = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'AVP' ORDER BY tbl_user_id DESC`, [userIds]);

        // Fetch BM data based on userIds
        const mdbmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'BM' ORDER BY tbl_user_id DESC`, [userIds]);                

        // Fetch SRM data based on userIds        
        const mdsrmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'SRM' ORDER BY tbl_user_id DESC`, [userIds]); 

        // Fetch RM data based on userIds        
        const mdrmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'RM' ORDER BY tbl_user_id DESC`, [userIds]);  
        
        // console.log('mdavpusr_data.rows', mdavpusr_data.rows);
        

        // Render the page with fetched data
        res.render('create_team', {
            layout: true,
            md_user_id: md_user_id,
            mdusr_data: mdusr_data.rows,  // Assuming single record for MD
            vplist_data: vplistdata.rows,
            avplist_data: avplistdata.rows,
            mdvplist_data: mdvpusr_data.rows,
            mdavplist_data: mdavpusr_data.rows,
            bmlist_data: bmlistdata.rows,
            ////// assign md to srm data ////
            mbbm_list_data: mdbmresult.rows,
            srm_list_data: srmlistResult.rows,
            rm_list_data: rmlistResult.rows,
            ////// assign srm to emp data ////
            mb_srm_list_data: mdsrmresult.rows,
            mb_rm_list_data: mdrmresult.rows,
            emp_list_data: EMPlistResult.rows,
            pagetitle: 'md_user_page'
        });

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/md_assign_new_vp', auth, async (req, res) => {
    const { md_user_id, vp_id_arr } = req.body;

    try {
        // Check if vp_user_id exists in tbl_user
        const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
        const userCheckResult = await pool.query(userCheckQuery, [md_user_id]);

        if (userCheckResult.rows[0].user_exists == 0) {
            return res.status(201).json({ status: false, message: 'VP User ID not found.' });
        }

        // Split the vp_id_arr string into an array
        const vpIdArray = vp_id_arr.split(',');

        // Loop over the BM ids and insert them into tbl_user_connection
        let insertCount = 0;
        for (let i = 0; i < vpIdArray.length; i++) {
            const vp_id = vpIdArray[i];

            // Insert each BM with the corresponding VP
            const insertQuery = `INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id) VALUES ($1, $2)`;
            const insertResult = await pool.query(insertQuery, [vp_id, md_user_id]);

          if (insertResult.rowCount > 0){ insertCount++; }
        }
        if (insertCount > 0) {
            return res.json({ status: true, message: `${insertCount} VP(s) assigned by MD successfully.` });
        } else {
            return res.status(200).json({ status: false, message: 'Failed to assign VP(s) by MD.' });
        }
    } catch (error) {
        console.error('Error assigning MD to VP(s):', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

app.post('/vp_assign_new_bm', auth, async (req, res) => {
    const { vp_user_id, bm_id_arr } = req.body;
    try {
        // Check if vp_user_id exists in tbl_user
        const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
        const userCheckResult = await pool.query(userCheckQuery, [vp_user_id]);

        if (userCheckResult.rows[0].user_exists == 0) {
            return res.status(201).json({ status: false, message: 'VP User ID not found.' });
        }

        // Split the avp_id_arr string into an array
        const bmIdArray = bm_id_arr.split(',');

        // Loop over the BM ids and insert them into tbl_user_connection
        let insertCount = 0;
        for (let i = 0; i < bmIdArray.length; i++) {
            const bm_id = bmIdArray[i];

            // Insert each BM with the corresponding VP
            const insertQuery = `INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id) VALUES ($1, $2)`;
            const insertResult = await pool.query(insertQuery, [bm_id, vp_user_id]);

            if (insertResult.rowCount > 0) {
                insertCount++;
            }
        }

        if (insertCount > 0) {
            return res.json({ status: true, message: `${insertCount} BM(s) assigned by VP successfully.` });
        } else {
            return res.status(200).json({ status: false, message: 'Failed to assign BM(s) by VP.' });
        }

    } catch (error) {
        console.error('Error assigning VP to BM(s):', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

// app.post('/vp_assign_new_avp', async (req, res) => {
//     const { vp_user_id, avp_id_arr } = req.body;
//     try {
//         // Check if vp_user_id exists in tbl_user
//         const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
//         const userCheckResult = await pool.query(userCheckQuery, [vp_user_id]);

//         if (userCheckResult.rows[0].user_exists == 0) {
//             return res.status(201).json({ status: false, message: 'VP User ID not found.' });
//         }

//         // Split the avp_id_arr string into an array
//         const avpIdArray = avp_id_arr.split(',');

//         // Loop over the BM ids and insert them into tbl_user_connection
//         let insertCount = 0;
//         for (let i = 0; i < avpIdArray.length; i++) {
//             const avp_id = avpIdArray[i];

//             // Insert each BM with the corresponding VP
//             const insertQuery = `INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id) VALUES ($1, $2)`;
//             const insertResult = await pool.query(insertQuery, [avp_id, vp_user_id]);

//             if (insertResult.rowCount > 0) {
//                 insertCount++;
//             }
//         }

//         if (insertCount > 0) {
//             return res.json({ status: true, message: `${insertCount} AVP(s) assigned by VP successfully.` });
//         } else {
//             return res.status(200).json({ status: false, message: 'Failed to assign AVP(s) by VP.' });
//         }

//     } catch (error) {
//         console.error('Error assigning VP to AVP(s):', error);
//         res.status(500).json({ status: false, message: 'Server error, please try again later.' });
//     }
// });

app.post('/bm_assign_new_avp', auth, async (req, res) => {
    const { mdbm_user_id, avp_id_arr } = req.body;
    try {
        // Check if vp_user_id exists in tbl_user
        const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
        const userCheckResult = await pool.query(userCheckQuery, [mdbm_user_id]);

        if (userCheckResult.rows[0].user_exists == 0) {
            return res.status(201).json({ status: false, message: 'BM User ID not found.' });
        }

        // Split the bm_id_arr string into an array
        const avpIdArray = avp_id_arr.split(',');

        // Loop over the BM ids and insert them into tbl_user_connection
        let insertCount = 0;
        for (let i = 0; i < avpIdArray.length; i++) {
            const avp_id = avpIdArray[i];

            // Insert each BM with the corresponding VP
            const insertQuery = `INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id) VALUES ($1, $2)`;
            const insertResult = await pool.query(insertQuery, [avp_id, mdbm_user_id]);

            if (insertResult.rowCount > 0) {
                insertCount++;
            }
        }

        if (insertCount > 0) {
            return res.json({ status: true, message: `${insertCount} AVP(s) assigned by BM successfully.` });
        } else {
            return res.status(200).json({ status: false, message: 'Failed to assign AVP(s) by BM.' });
        }

    } catch (error) {
        console.error('Error assigning AVP to AVP(s):', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

app.post('/avp_assign_new_srm', auth, async (req, res) => {
   
    const { avp_user_id, srm_id_arr, type_d_abbr } = req.body;

    console.log('avp_assign_new_srm', req.body);
    

    try {
        // Check if avp_user_id exists in tbl_user
        const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
        const userCheckResult = await pool.query(userCheckQuery, [avp_user_id]);

        if (userCheckResult.rows[0].user_exists == 0) {
            return res.status(201).json({ status: false, message: `${type_d_abbr} User ID not found.` });
        }

        // Split the bm_id_arr string into an array
        const srmIdArray = srm_id_arr.split(',');

        // Loop over the BM ids and insert them into tbl_user_connection
        let insertCount = 0;
        for (let i = 0; i < srmIdArray.length; i++) {
            const srm_id = srmIdArray[i];

            // Insert each BM with the corresponding VP
            const insertQuery = `INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id) VALUES ($1, $2)`;
            const insertResult = await pool.query(insertQuery, [srm_id, avp_user_id]);

            if (insertResult.rowCount > 0) {
                insertCount++;
            }
        }

        if (insertCount > 0) {
            return res.json({ status: true, message: `${insertCount} SRM(s) assigned by ${type_d_abbr} successfully.` });
        } else {
            return res.status(200).json({ status: false, message: `Failed to assign SRM(s) by ${type_d_abbr}.` });
        }

    } catch (error) {
        console.error('Error assigning VP to AVP(s):', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

app.post('/srm_assign_new_rm', auth, async (req, res) => {
   
    const { mdsrm_user_id, rm_id_arr, type_d_abbr } = req.body;

    try {
        // Check if mdbm_user_id exists in tbl_user
        const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
        const userCheckResult = await pool.query(userCheckQuery, [mdsrm_user_id]);

        if (userCheckResult.rows[0].user_exists == 0) {
            return res.status(201).json({ status: false, message: `${type_d_abbr} User ID not found.` });
        }

        // Split the bm_id_arr string into an array
        const rmIdArray = rm_id_arr.split(',');

        // Loop over the BM ids and insert them into tbl_user_connection
        let insertCount = 0;
        for (let i = 0; i < rmIdArray.length; i++) {
            const rm_id = rmIdArray[i];

            // Insert each BM with the corresponding VP
            const insertQuery = `INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id) VALUES ($1, $2)`;
            const insertResult = await pool.query(insertQuery, [rm_id, mdsrm_user_id]);

            if (insertResult.rowCount > 0) {
                insertCount++;
            }
        }

        if (insertCount > 0) {
            return res.json({ status: true, message: `${insertCount} RM(s) assigned by ${type_d_abbr} successfully.` });
        } else {
            return res.status(200).json({ status: false, message: `Failed to assign RM(s) by ${type_d_abbr}.` });
        }

    } catch (error) {
        console.error('Error assigning SRM to RM(s):', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

app.post('/rm_assign_new_emp', auth, async (req, res) => {
   
    const { mdrm_user_id, emp_id_arr, type_d_abbr } = req.body;

    try {
        // Check if mdbm_user_id exists in tbl_user
        const userCheckQuery = `SELECT COUNT(*) AS user_exists FROM tbl_user WHERE tbl_user_id = $1`;
        const userCheckResult = await pool.query(userCheckQuery, [mdrm_user_id]);

        if (userCheckResult.rows[0].user_exists == 0) {
            return res.status(201).json({ status: false, message: `${type_d_abbr} User ID not found.` });
        }

        // Split the bm_id_arr string into an array
        const empIdArray = emp_id_arr.split(',');

        // Loop over the BM ids and insert them into tbl_user_connection
        let insertCount = 0;
        for (let i = 0; i < empIdArray.length; i++) {
            const emp_id = empIdArray[i];

            // Insert each BM with the corresponding VP
            const insertQuery = `INSERT INTO tbl_user_connection (tbl_user_id, tbl_parent_id) VALUES ($1, $2)`;
            const insertResult = await pool.query(insertQuery, [emp_id, mdrm_user_id]);

            if (insertResult.rowCount > 0) {
                insertCount++;
            }
        }

        if (insertCount > 0) {
            return res.json({ status: true, message: `${insertCount} EMP(s) assigned by ${type_d_abbr} successfully.` });
        } else {
            return res.status(200).json({ status: false, message: `Failed to assign EMP(s) by ${type_d_abbr}.` });
        }

    } catch (error) {
        console.error('Error assigning RM to EMP(s):', error);
        res.status(500).json({ status: false, message: 'Server error, please try again later.' });
    }
});

////////////////////////////////// md create team code end here ///////////////////////////

////////////////////////////////// md edit team code start from here //////////////////

app.get('/md_edit_team/:md_user_id', auth, async (req, res) => {
    const { md_user_id } = req.params;

    try {
        // Fetch all required data concurrently using Promise.all
        const [mdusr_data, mdvpusr_data, vplistdata, avplistdata, bmlistdata, childUsersResult, srmlistResult, rmlistResult, EMPlistResult ] = await Promise.all([
            pool.query(`SELECT full_name as md_name, mobile FROM tbl_user WHERE tbl_user_id = $1 AND designation_abbr = 'MD'`, [md_user_id]),

            pool.query(`SELECT u.tbl_user_id, u.full_name, ucn.* FROM tbl_user u INNER JOIN tbl_user_connection ucn ON u.tbl_user_id = ucn.tbl_user_id WHERE ucn.tbl_parent_id = $1 AND u.status != 5 AND u.designation_abbr = 'VP' ORDER BY ucn.tbl_user_id DESC`, [md_user_id]),

            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'VP' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'AVP' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'BM' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `, [md_user_id]),

            //// free for assign srm list
            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'SRM' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'RM' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

            //// free for assign EMP list
            pool.query(`SELECT u.tbl_user_id, u.full_name FROM tbl_user u WHERE u.status != 5 AND u.designation_abbr = 'EMP' AND NOT EXISTS (SELECT 1 FROM tbl_user_connection c WHERE c.tbl_user_id = u.tbl_user_id)`),

        ]);

        // Extract user IDs from the recursive query result
        const userIds = childUsersResult.rows.map(row => row.tbl_user_id);        

        // Fetch AVP data based on userIds
        const mdavpresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'AVP' ORDER BY tbl_user_id DESC`, [userIds]);

        // Fetch BM data based on userIds
        const mdbmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'BM' ORDER BY tbl_user_id DESC`, [userIds]);
        
        // Fetch SRM data based on userIds        
        const mdsrmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'SRM' ORDER BY tbl_user_id DESC`, [userIds]);   

        // Fetch SRM data based on userIds        
        const mdrmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'RM' ORDER BY tbl_user_id DESC`, [userIds]);        

        // Render the page with fetched data
        res.render('md_edit_team', {
            layout: true,
            md_user_id: md_user_id,
            mdusr_data: mdusr_data.rows,  // Assuming single record for MD
            mdvplist_data: mdvpusr_data.rows,
            vplist_data: vplistdata.rows,
            avplist_data: avplistdata.rows,
            mbavplist_data: mdavpresult.rows,
            bmlist_data: bmlistdata.rows,
            ////// assign md to srm data ////
            mbbm_list_data: mdbmresult.rows,
            srm_list_data: srmlistResult.rows,
            rm_list_data: rmlistResult.rows,
            ////// assign srm to emp data ////
            mb_srm_list_data: mdsrmresult.rows,
            mb_rm_list_data: mdrmresult.rows,
            emp_list_data: EMPlistResult.rows,
            pagetitle: 'md_user_page'
        });

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/new_vp_replace_by_old_vp', auth, async(req, res) => {

    const { md_user_id, old_vp_userId, newvp_id } = req.body;

    try {
        pool.query(`SELECT tbl_user_id FROM tbl_user where tbl_user_id = '${old_vp_userId}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }
            if (result_res.rowCount > 0) {
              
                // Perform the update
                const updateParent = await pool.query(`UPDATE tbl_user_connection SET tbl_parent_id = $1 WHERE tbl_parent_id = $2 RETURNING *`, [newvp_id, old_vp_userId]);

                const updateUser = await pool.query(`UPDATE tbl_user_connection SET tbl_user_id = $1 WHERE tbl_user_id = $2 RETURNING *`, 
                    [newvp_id, old_vp_userId] );

                if (updateParent.rowCount > 0 || updateUser.rowCount > 0) {
                    return res.json({ status: true, message: `New VP is assigned successfully.`});
                } else {
                    return res.json({ status: false, message: 'No records updated. Old VP might not have any connections.' });
                }
                ////
            } else {
                return res.json({ status: false, message: 'Old VP user id is not exist.' });                
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/get_bm_by_vp_userid', auth, async (req, res) => {

    const { vp_userId } = req.body;

    try {
        // Fetch all required data concurrently using
        const [childUsersResult] = await Promise.all([
            pool.query(`
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `, [vp_userId]),
        ]);

        // Extract user IDs from the recursive query result
        const userIds = childUsersResult.rows.map(row => row.tbl_user_id);

        // Fetch BM data based on userIds
        const mdbmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'BM' ORDER BY tbl_user_id DESC`, [userIds]);

        if (mdbmresult.rowCount > 0) {
            res.status(201).json({ status: true, data: mdbmresult.rows, });
        } else {
            res.status(201).json({ status: false, data: [], });
        }

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/new_bm_replace_by_old_bm',auth,  async(req, res) => {

    const { selectet_vpuser_id, old_bm_userId, newbm_id } = req.body;

    try {
        pool.query(`SELECT tbl_user_id FROM tbl_user where tbl_user_id = '${old_bm_userId}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }
            if (result_res.rowCount > 0) {
              
                // Perform the update
                const updateParent = await pool.query(`UPDATE tbl_user_connection SET tbl_parent_id = $1 WHERE tbl_parent_id = $2 RETURNING *`, [newbm_id, old_bm_userId]);

                const updateUser = await pool.query(`UPDATE tbl_user_connection SET tbl_user_id = $1 WHERE tbl_user_id = $2 RETURNING *`, 
                    [newbm_id, old_bm_userId] );

                if (updateParent.rowCount > 0 || updateUser.rowCount > 0) {
                    return res.json({ status: true, message: `New BM is assigned successfully.` });
                } else {
                    return res.json({ status: false, message: 'No records updated. Old BM might not have any connections.' });
                }
                ////
            } else {
                return res.json({ status: false, message: 'Old BM user id is not exist.' });                
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/get_srm_by_avp_userid', auth, async (req, res) => {

    const { avp_userId } = req.body;

    try {
        // Fetch all required data concurrently using
        const [childUsersResult] = await Promise.all([
            pool.query(`
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `, [avp_userId]),
        ]);

        // Extract user IDs from the recursive query result
        const userIds = childUsersResult.rows.map(row => row.tbl_user_id);

        // Fetch BM data based on userIds
        const mdsrmresult = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'SRM' ORDER BY tbl_user_id DESC`, [userIds]);

        if (mdsrmresult.rowCount > 0) {
            res.status(201).json({ status: true, data: mdsrmresult.rows, });
        } else {
            res.status(201).json({ status: false, data: [], });
        }

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/new_avp_replace_by_old_avp', auth, async(req, res) => {

    const { selectet_bmuser_id, old_avp_userId, newavp_id } = req.body;

    try {
        pool.query(`SELECT tbl_user_id FROM tbl_user where tbl_user_id = '${old_avp_userId}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }
            if (result_res.rowCount > 0) {
              
                // Perform the update
                const updateParent = await pool.query(`UPDATE tbl_user_connection SET tbl_parent_id = $1 WHERE tbl_parent_id = $2 RETURNING *`, [newavp_id, old_avp_userId]);

                const updateUser = await pool.query(`UPDATE tbl_user_connection SET tbl_user_id = $1 WHERE tbl_user_id = $2 RETURNING *`, 
                    [newavp_id, old_avp_userId] );

                if (updateParent.rowCount > 0 || updateUser.rowCount > 0) {
                    return res.json({ status: true, message: `New AVP is assigned successfully.` });
                } else {
                    return res.json({ status: false, message: 'No records updated. Old AVP might not have any connections.' });
                }                
            } else {
                return res.json({ status: false, message: 'Old AVP user id is not exist.' });                
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/get_avp_by_bm_userid', auth, async (req, res) => {

    const { bm_userId } = req.body;

    try {
        // Fetch all required data concurrently using
        const [childUsersResult] = await Promise.all([
            pool.query(`
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `, [bm_userId]),
        ]);

        // Extract user IDs from the recursive query result
        const userIds = childUsersResult.rows.map(row => row.tbl_user_id);

        // Fetch BM data based on userIds
        const mdavp_result = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'AVP' ORDER BY tbl_user_id DESC`, [userIds]);

        console.log('mdavp_result', mdavp_result.rows);
        
        
        if (mdavp_result.rowCount > 0) {
            res.status(201).json({ status: true, data: mdavp_result.rows, });
        } else {
            res.status(201).json({ status: false, data: [], });
        }

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/new_srm_replace_by_old_srm', auth, async (req, res) => {

    const { selectet_avpuser_id, old_srm_userId, newsrm_id } = req.body;

    try {
        // Check if old SRM exists
        const result_res = await pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [old_srm_userId]);

        if (result_res.rowCount === 0) {
            return res.json({ status: false, message: 'Old SRM user id does not exist.' });
        }

        // Perform the update
        const updateParent = await pool.query(
            `UPDATE tbl_user_connection SET tbl_parent_id = $1 WHERE tbl_parent_id = $2 RETURNING *`, 
            [newsrm_id, old_srm_userId]
        );

        const updateUser = await pool.query(
            `UPDATE tbl_user_connection SET tbl_user_id = $1 WHERE tbl_user_id = $2 RETURNING *`, 
            [newsrm_id, old_srm_userId]
        );

        if (updateParent.rowCount > 0 || updateUser.rowCount > 0) {
            return res.json({ status: true, message: `New SRM is assigned successfully.` });
        } else {
            return res.json({ status: false, message: 'No records updated. Old SRM might not have any connections.' });
        }
    } catch (error) {
        console.error('Error updating data:', error);
        res.status(500).json({ status: false, message: 'Error updating data' });
    }
});

app.post('/get_rm_by_srm_userid', auth, async (req, res) => {

    const { srm_userId } = req.body;

    try {
        // Fetch all required data concurrently using
        const [childUsersResult] = await Promise.all([
            pool.query(`
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `, [srm_userId]),
        ]);

        // Extract user IDs from the recursive query result
        const userIds = childUsersResult.rows.map(row => row.tbl_user_id);

        // Fetch BM data based on userIds
        const mdrm_result = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'RM' ORDER BY tbl_user_id DESC`, [userIds]);
        
        if (mdrm_result.rowCount > 0) {
            res.status(201).json({ status: true, data: mdrm_result.rows, });
        } else {
            res.status(201).json({ status: false, data: [], });
        }

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/get_emp_by_rm_userid', auth, async (req, res) => {

    const { rm_userId } = req.body;

    try {
        // Fetch all required data concurrently using
        const [childUsersResult] = await Promise.all([
            pool.query(`
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `, [rm_userId]),
        ]);

        // Extract user IDs from the recursive query result
        const userIds = childUsersResult.rows.map(row => row.tbl_user_id);

        // Fetch BM data based on userIds
        const mdemp_result = await pool.query(`SELECT tbl_user_id, full_name FROM tbl_user WHERE tbl_user_id = ANY($1) AND designation_abbr = 'EMP' ORDER BY tbl_user_id DESC`, [userIds]);
        
        if (mdemp_result.rowCount > 0) {
            res.status(201).json({ status: true, data: mdemp_result.rows, });
        } else {
            res.status(201).json({ status: false, data: [], });
        }

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/new_rm_replace_by_old_rm', auth, async (req, res) => {
    const { selectet_srmuser_id, old_rm_userId, newrm_id } = req.body;
  

    try {
        // Check if old SRM exists
        const result_res = await pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [old_rm_userId]);

        if (result_res.rowCount === 0) {
            return res.json({ status: false, message: 'Old RM user id does not exist.' });
        }

        // Perform the update
        const updateParent = await pool.query(
            `UPDATE tbl_user_connection SET tbl_parent_id = $1 WHERE tbl_parent_id = $2 RETURNING *`, 
            [newrm_id, old_rm_userId]
        );

        const updateUser = await pool.query(
            `UPDATE tbl_user_connection SET tbl_user_id = $1 WHERE tbl_user_id = $2 RETURNING *`, 
            [newrm_id, old_rm_userId]
        );

        if (updateParent.rowCount > 0 || updateUser.rowCount > 0) {
            return res.json({ status: true, message: `New RM is assigned successfully.` });
        } else {
            return res.json({ status: false, message: 'No records updated. Old RM might not have any connections.' });
        }
    } catch (error) {
        console.error('Error updating data:', error);
        res.status(500).json({ status: false, message: 'Error updating data' });
    }
});

app.post('/new_emp_replace_by_old_emp', auth, async (req, res) => {

    const { selectet_srmuser_id, old_emp_userId, newemp_id } = req.body;

    try {
        // Check if old SRM exists
        const result_res = await pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [old_emp_userId]);

        if (result_res.rowCount === 0) {
            return res.json({ status: false, message: 'Old EMP user id does not exist.' });
        }

        // Perform the update
        const updateParent = await pool.query(
            `UPDATE tbl_user_connection SET tbl_parent_id = $1 WHERE tbl_parent_id = $2 RETURNING *`, 
            [newemp_id, old_emp_userId]
        );

        const updateUser = await pool.query(
            `UPDATE tbl_user_connection SET tbl_user_id = $1 WHERE tbl_user_id = $2 RETURNING *`, 
            [newemp_id, old_emp_userId]
        );

        if (updateParent.rowCount > 0 || updateUser.rowCount > 0) {
            return res.json({ status: true, message: `New EMP is assigned successfully.` });
        } else {
            return res.json({ status: false, message: 'No records updated. Old EMP might not have any connections.' });
        }
    } catch (error) {
        console.error('Error updating data:', error);
        res.status(500).json({ status: false, message: 'Error updating data' });
    }
});
////////////////////////////////// md edit team code end here ///////////////////////////

////////////////////////////////// md view team code start from here //////////////////
app.get('/md_view_team/:md_user_id', auth, async (req, res) => {
    const { md_user_id } = req.params;

    try {
        // Fetch MD details
        const mdResult = await pool.query(
            `SELECT tbl_user_id, full_name, designation_abbr FROM tbl_user WHERE tbl_user_id = $1 AND designation_abbr = 'MD'`,
            [md_user_id]
        );

        if (mdResult.rows.length === 0) {
            return res.status(404).send("MD not found.");
        }

        const mdData = mdResult.rows[0];

        // Fetch all child users under MD recursively
        const childUsersResult = await pool.query(
            `WITH RECURSIVE RecursiveCTE AS (
                SELECT tbl_user_id, tbl_user_connection_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                UNION ALL
                SELECT t.tbl_user_id, t.tbl_user_connection_id, t.tbl_parent_id FROM tbl_user_connection t 
                INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
            )
            SELECT u.tbl_user_id, u.full_name, u.designation_abbr, c.tbl_user_connection_id, c.tbl_parent_id
            FROM RecursiveCTE c
            JOIN tbl_user u ON u.tbl_user_id = c.tbl_user_id
            ORDER BY c.tbl_parent_id, u.tbl_user_id;`,
            [md_user_id]
        );

        // Function to build a hierarchical tree
        function buildTree(users, parentId) {
            return users
                .filter(user => user.tbl_parent_id == parentId)
                .map(user => ({
                    ...user,
                    children: buildTree(users, user.tbl_user_id)
                }));
        }

        const teamTree = buildTree(childUsersResult.rows, mdData.tbl_user_id);

        // Function to generate HTML recursively
        function generateTreeHTML(users) {
            if (!users.length) return '';
            let html = '<ul>';
            users.forEach(user => {
                //console.log('user.tbl_user_connection_id', user.tbl_user_connection_id);
                //console.log('user.full_name', user.full_name);
               // console.log('user.children', user.children.length);
                
                if(user.designation_abbr.toLowerCase() == 'md' || user.designation_abbr.toLowerCase() == 'vp' || user.designation_abbr.toLowerCase() == 'bm' || user.children.length != 0){
                    btnshow = ``;
                }else{
                    btnshow = `<button onclick="openModal(46)" style=" color: red; border: 2px solid red;border-radius: 5px; padding: 2px 10px; margin-left: 10px; cursor: pointer;">Remove</button>`;
                }
                html += `
                    <li class="${user.designation_abbr.toLowerCase()}" id="teamid_${user.tbl_user_connection_id}" onclick="$('#team_id').val(${user.tbl_user_connection_id})">
                        ${user.full_name} (${user.designation_abbr})
                        ${btnshow}
                        ${generateTreeHTML(user.children)}
                    </li>
                    
                `;
            });
            html += '</ul>';
            return html;
        }

        const teamTreeHTML = generateTreeHTML(teamTree);

        res.render('md_view_team', {
            layout : true,
            md_data: mdData,  
            team_tree_html: teamTreeHTML,  
            pagetitle: 'md_user_page'
        });
    } catch (error) {
        console.error('Error fetching team data:', error);
        res.status(500).send('Error fetching team data');
    }
});

app.post('/user_delete_from_team', auth, async (req, res) => {

    const { teamid } = req.body;
    try {
        const result_res = await pool.query(`SELECT * FROM tbl_user_connection WHERE tbl_user_connection_id = $1`, [teamid]);

        if (result_res.rowCount === 0) {
            return res.json({ status: false, message: 'Team id does not exist.'});
        }

        const updateteam = await pool.query(`DELETE FROM tbl_user_connection WHERE tbl_user_connection_id = $1`,[teamid]);

        if (updateteam.rowCount > 0) {

            const teamdata = result_res.rows[0];
            const teamdelete_history = await pool.query(`INSERT INTO tbl_user_connection_history(tbl_user_connection_id, tbl_user_id, tbl_parent_id) VALUES($1, $2, $3)`,
                [teamid, teamdata.tbl_user_id, teamdata.tbl_parent_id]
            );
            if (teamdelete_history.rowCount > 0) {
                return res.json({ status: true, message: `User removed from team successfully.`});
            } else {
                return res.json({ status: false, message: 'No user remove from team.'});
            }    
        } else {
            return res.json({ status: false, message: 'No user remove from team.'});
        }
    } catch (error) {
        console.error('Error removing data:', error);
        res.status(500).json({ status: false, message: 'Error removing data' });
    }
});
////////////////////////////// md view team code end here ///////////////////////////


///////////////////////////////// MD User Code start here //////////////////////


///////////////////////////////// admin Code end here //////////////////////


/////////////////////////////////  👍👍👍👌👌👍👌👌👌👌👌👌👍👌👌👌 /////////////////////////

app.get('/error_page', auth, function (req, res) {
    res.status(404).render('404_page', {
        pagetitle: ''
    })
})

app.get('*', auth, function (req, res) {
    res.status(404).render('404_page', {
        pagetitle: ''
    })
})

app.listen(8113);
console.log('8113 is the magic port');