// load the things we need
var express = require('express');
var cookieParser = require('cookie-parser');
var session = require('express-session');
var app = express();
var bodyParser = require('body-parser');
var axios = require('axios');
const expressLayout = require('express-ejs-layouts');
const moment = require('moment');
const path = require('path');
const pg = require('pg');
const formidable = require('formidable');
const dbConfig = require('../db');
const pool = new pg.Pool(dbConfig);
var apiurl = "http://wealthyfy.ojpasoftware.com:8112";
const  img_base_url = "http://wealthyfy.ojpasoftware.com:8112/files/upload";
const jwt = require('jsonwebtoken');

// use res.render to load up an ejs view file
app.use(express.static("views"));
app.use('/', express.static(path.join(__dirname, '/public')));
app.use('/:a', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b/:c', express.static(path.join(__dirname, '/public')));

app.use(expressLayout)
app.set('views', path.join(__dirname, 'templates/views'));
app.set('view engine', 'ejs');

// Latest version - v3.0.0
app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json({ limit: "150mb" }))

app.use(cookieParser());
app.use(session({ 
    secret: "Expense",
    cookie: { maxAge: 1000 * 60 * 60 * 24 * 7 },
    resave: true,
    saveUninitialized: true
}));

///////////////////////////// create token function  ///////////////////////
const createToken = (id) => {
    return jwt.sign({ id }, 'wlfy954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}
///////////////////////////// create token function  ///////////////////////

// Mock database for demonstration purposes
let userSessions = {}; // { userId: sessionId }

const auth = function (req, res, next) {
    if (req.session.supadminid) {
        if(userSessions[req.session.supadminid] === req.session.id){
          next();
        }else{
            // Session ID does not match, log the user out
            req.session.destroy(() => {
                res.redirect('/');
            });
        }
    } else {
        res.redirect('/');
    }
}

// Middleware to check if the user is not authenticated
const unauth = function (req, res, next) {
    if (req.session.supadminid && userSessions[req.session.supadminid] === req.session.id) {
        // If the user is authenticated, redirect them to another page (e.g., dashboard)
        res.redirect('/dashboard'); // Change '/dashboard' to whatever page you want to redirect to
    } else {
        // If not authenticated, allow access to the login page
        next();
    }
};


app.use(function (req, res, next) {
    var err = req.session.error;
    delete req.session.error;
    res.locals.imgbaseurl = img_base_url;
    res.locals.moment = moment;
    res.locals.super_admin_id = req.session.supadminid;
    res.locals.user_name = req.session.username;
    res.locals.user_email = req.session.email;
    res.locals.user_pageno = req.session.user_list_page_no;
    res.locals.error = err;
    next();
});

app.get('/logout', function (req, res) {
    req.session.destroy(function () {
       res.redirect('/');
    });
})

app.get('/', unauth, function (req, res) {
    res.setHeader('Cache-Control', 'no-store');     // Prevent caching of the login page
    // res.setHeader('Pragma', 'no-cache');        // HTTP 1.0
    //res.setHeader('Expires', '0');              // Proxies

    res.render('login', {
        layout : false,
    });
});


// login page submit
app.post('/sub_admin_login', function (req, res) {

    const { email, password } = req.body;

    pool.query(`SELECT * FROM tbl_user WHERE email = '${email}' AND status = 1 AND designation_abbr = 'MD'`, async(error, result) => {
        if (error) {
            return res.status(201).json({ status: false, message: error.message, msg : "logi" })
        }
        var count = result.rowCount;
        if (count > 0) {

            if(result.rows[0].password == password)
            {

                const resdata = result.rows;

                const userId = resdata[0].tbl_user_id;
                req.session.supadminid = userId;
                req.session.username = resdata[0].full_name;
                req.session.email = resdata[0].email;
                // Save the session ID to the database
                userSessions[userId] = req.session.id;
                
               res.redirect('/dashboard');
            }else{
                res.render('login', { layout: false, error : 'You Entered Wrong Password', });
            }
        }else{
            res.render('login', { layout: false, error : 'You Entered Wrong Details', });
        }
    })
});

app.get('/dashboard', auth, async(req, res)=> {

    ///////////// get team id code start from here ////////////////////////////////
    // const md_user_id = '2';
    const md_user_id = req.session.supadminid;
    const recursivequery = `
        WITH RECURSIVE RecursiveCTE AS (
        SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_parent_id = $1

        UNION ALL

        SELECT t.tbl_user_id, t.tbl_parent_id 
        FROM tbl_user_connection t 
        INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
        )
        SELECT tbl_user_id FROM RecursiveCTE;
    `;
    const childUsersResult = await pool.query(recursivequery, [md_user_id]);
    userIds = childUsersResult.rows.map(row => row.tbl_user_id);


    ///////////// get team id code start from here ////////////////////////////////
    const result = await pool.query(`
        SELECT (SELECT count(tbl_user_id) FROM tbl_user where status != 5 AND tbl_user_id = ANY($1)) as total_user,       
        (SELECT count(tbl_attendance_id) FROM tbl_attendance where tbl_user_id = ANY($1)) as total_attendance,
        (SELECT count(tbl_meeting_id) FROM tbl_meeting where tbl_user_id = ANY($1)) as total_meeting,
        (SELECT count(tbl_user_leave_id) FROM tbl_user_leave  where tbl_user_id = ANY($1)) as total_user_leave
    `, [userIds]);
    const admn_data = result.rows;

    res.render('dashboard', {
        layout : true,
        admn_data : admn_data,
        pagetitle: 'dashboard',
    });
});

///////////////////////////////////// all user leave code start from here ///////////////////////

app.get('/user_leave_list', auth, async (req, res) => {
    
    try {

        const md_user_id = req.session.supadminid;
        // const md_user_id = '2';

        ///////////// get team id code start from here ////////////////////////////////
          const recursivequery = `
          WITH RECURSIVE RecursiveCTE AS (
          SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_parent_id = $1

          UNION ALL

          SELECT t.tbl_user_id, t.tbl_parent_id 
          FROM tbl_user_connection t 
          INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
          )
          SELECT tbl_user_id FROM RecursiveCTE;
      `;
      const childUsersResult = await pool.query(recursivequery, [md_user_id]);
      userIds = childUsersResult.rows.map(row => row.tbl_user_id);
      
      ///////////// get team id code start from here ////////////////////////////////

        const result = await pool.query(`SELECT o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
            ul.* FROM tbl_user_leave ul 
            LEFT JOIN tbl_user u ON ul.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON ul.tbl_office_id = o. tbl_office_id 
            LEFT JOIN tbl_user ua ON ul.leave_approved_reject_by_user_id = ua.tbl_user_id where u.tbl_user_id = ANY($1)
            ORDER BY ul.tbl_user_leave_id DESC;`, [userIds]);
        const leave_data = result.rows;

        res.render('user_leave_list', {
            layout: true,
            leave_data: leave_data,
            pagetitle: 'leav_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/user_leave_detail/:user_leaveid', auth, async (req, res) => {

    const { user_leaveid } = req.params;

    try {
        const result = await pool.query(`SELECT o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
            ul.* FROM tbl_user_leave ul 
            LEFT JOIN tbl_user u ON ul.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON ul.tbl_office_id = o. tbl_office_id 
            LEFT JOIN tbl_user ua ON ul.leave_approved_reject_by_user_id = ua.tbl_user_id where tbl_user_leave_id = $1`, [user_leaveid]);
        const leave_data = result.rows;        

        res.render('user_leave_detail', {
            layout: true,
            leave_data: leave_data,
            pagetitle: 'leav_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/leave_status_update', auth, async (req, res) => {

    const { tbl_user_leave_id, status, leave_reject_reason } = req.body;

    if (leave_reject_reason == '' || leave_reject_reason == null || leave_reject_reason == undefined) {
        var reason1 = ''
    } else {
        var reason1 = leave_reject_reason;
    }
    try {
        pool.query(`SELECT * FROM tbl_user_leave where tbl_user_leave_id = '${tbl_user_leave_id}'`, async (error, result_res) => {
            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {

                if (result_res.rows[0].status == 'rejected' || result_res.rows[0].status == 'approved') {
                    return res.status(500).json({ status: false, message: `This leave is already ${result_res.rows[0].status}.`});

                } else {

                    const userQuery = await pool.query(`SELECT tbl_user_id, firebase_tokens as user_firebasetoken from tbl_user where tbl_user_id = '${result_res.rows[0].tbl_user_id}' AND status = '1'`);

                    /// update meeting details query

                    const updt_leav_query = `UPDATE tbl_user_leave SET status = '${status}', leave_approved_reject_by_user_id = '0',   leave_approved_reject_by_user_type = 'Admin', leave_approved_reject_date_time = now(), leave_rejected_reason = $$${reason1}$$ where tbl_user_leave_id = '${tbl_user_leave_id}'`;

                    try {
                        const leav_updtResult = await pool.query(updt_leav_query);
                        if (leav_updtResult.rowCount > 0) {

                            const title = `Leave is ${status}`;
                            const notification_type = 'leave'
                            const notification_message = `Your ${result_res.rows[0].leave_type} is ${status} by Admin`;
                            const firebase_token = userQuery.rows[0].user_firebasetoken;
                            const meeting_leave_id = tbl_user_leave_id;
                            const tbl_userid = '0';
                            const parent_id = result_res.rows[0].tbl_user_id;

                            return res.status(201).json({ status: true, message: `Leave ${status} successfully.` });
                        } else {
                            return res.status(500).json({ status: false, message: 'Failed to update leave.' });
                        }
                    } catch (err) {
                        console.error(err);
                        return res.status(500).json({ status: false, message: 'Error occurred while updating leave.' });
                    }
                }
            } else {
                return res.status(201).json({ status: false, message: 'tbl_user_leave_id is wrong of this user.' });
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
    }
});

///////////////////////////////////// all user leave code end here ///////////////////////

///////////////////////////////////// user meeting code start from here ///////////////////////

app.get('/user_meeting_list', auth, async (req, res) => {
    try {

        //  const md_user_id = '2';
        const md_user_id = req.session.supadminid;

        ///////////// get team id code start from here ////////////////////////////////
        const recursivequery = `
            WITH RECURSIVE RecursiveCTE AS (
            SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_parent_id = $1

            UNION ALL

            SELECT t.tbl_user_id, t.tbl_parent_id 
            FROM tbl_user_connection t 
            INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
            )
            SELECT tbl_user_id FROM RecursiveCTE;
        `;
        const childUsersResult = await pool.query(recursivequery, [md_user_id]);
        userIds = childUsersResult.rows.map(row => row.tbl_user_id);

       
      
      ///////////// get team id code start from here ////////////////////////////////


        const result = await pool.query(`SELECT  o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
            tm.*  FROM  tbl_meeting tm 
            LEFT JOIN tbl_user u ON tm.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON tm.tbl_office_id = o.tbl_office_id 
            LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id 
            where u.tbl_user_id = ANY($1)
        ORDER BY tm.tbl_meeting_id DESC;`, [userIds]);

        const meting_data = result.rows;

        res.render('user_meeting_list', {
            layout: true,
            meting_data: meting_data,
            pagetitle: 'meting_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/meeting_detail/:meeting_id', auth, async (req, res) => {
    
    try {
        const { meeting_id } = req.params;

        const result = await pool.query(`SELECT  o.office_name, ua.full_name AS approved_by_user_name, u.full_name, u.designation_abbr, 
            tm.*  FROM  tbl_meeting tm 
            LEFT JOIN tbl_user u ON tm.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON tm.tbl_office_id = o.tbl_office_id 
            LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id where tm.tbl_meeting_id = ${meeting_id};`);

        const meting_data = result.rows;

        res.render('user_meeting_detail', {
            layout: true,
            meting_data: meting_data,
            pagetitle: 'meting_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/update_meeting_status', auth, async (req, res) => {
    const { tbl_meeting_id, status, reject_meeting_reason } = req.body;

    // Handle rejection reason
    const reason = reject_meeting_reason ? reject_meeting_reason : '';

    try {
        // Fetch meeting details
        pool.query(`SELECT * FROM tbl_meeting WHERE tbl_meeting_id = '${tbl_meeting_id}'`, async (error, result_res) => {
            if (error) {
                return res.status(403).json({ status: false, message: error });
            }

            if (result_res.rowCount > 0) {
                const meeting = result_res.rows[0];

                // Prevent updating already finalized meetings
                if (meeting.meeting_status === 'rejected' || meeting.meeting_status === 'approved') {
                    return res.status(201).json({ status: false, message: `This meeting is already ${meeting.meeting_status}.` });
                }

                // Fetch user details
                const userQuery = await pool.query(`SELECT tbl_user_id, firebase_tokens AS user_firebasetoken FROM tbl_user WHERE tbl_user_id = '${meeting.tbl_user_id}' AND status = '1'`);

                // Update meeting status
                const update_meeting_query = `UPDATE tbl_meeting SET meeting_status = '${status}', approved_reject_by_user_type = 'Admin', 
                approved_reject_by_user_date = NOW(), reason = $$${reason}$$ WHERE tbl_meeting_id = '${tbl_meeting_id}'`;

                try {
                    const meetingUpdateResult = await pool.query(update_meeting_query);
                    if (meetingUpdateResult.rowCount > 0) {
                        // Prepare notification
                        const title = `Meeting is ${status}`;
                        const notification_type = 'meeting';
                        const notification_message = `Your meeting has been ${status} by Admin`;
                        const firebase_token = userQuery.rows[0]?.user_firebasetoken || '';
                        const meeting_id = tbl_meeting_id;
                        const tbl_userid = '0';
                        const parent_id = meeting.tbl_user_id;

                        // Send notification (if implemented)
                        // all_user_notification.send_notification_to_user_by_firebase_token(title, notification_message, notification_type, 'user', tbl_userid, firebase_token, meeting_id, parent_id);

                        return res.status(200).json({ status: true, message: `Meeting ${status} successfully.` });
                    } else {
                        return res.status(500).json({ status: false, message: 'Failed to update meeting status.' });
                    }
                } catch (err) {
                    console.error(err);
                    return res.status(500).json({ status: false, message: 'Error occurred while updating meeting.' });
                }
            } else {
                return res.status(404).json({ status: false, message: 'Invalid tbl_meeting_id.' });
            }
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        return res.status(500).json({ status: false, message: 'Server error. Please try again later.' });
    }
});

///////////////////////////////////// meeting code end here ///////////////////////

///////////////////////////////////// atendnce code start from here ///////////////////////

app.get('/atendance_list', auth, async (req, res) => {
    try {

        //  const md_user_id = '2';
        const md_user_id = req.session.supadminid;

        ///////////// get team id code start from here ////////////////////////////////
        const recursivequery = `
            WITH RECURSIVE RecursiveCTE AS (
            SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_parent_id = $1

            UNION ALL

            SELECT t.tbl_user_id, t.tbl_parent_id 
            FROM tbl_user_connection t 
            INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
            )
            SELECT tbl_user_id FROM RecursiveCTE;
        `;
        const childUsersResult = await pool.query(recursivequery, [md_user_id]);
        userIds = childUsersResult.rows.map(row => row.tbl_user_id);

       
      
      ///////////// get team id code start from here ////////////////////////////////
        const result = await pool.query(`SELECT o.office_name, u.full_name, u.designation_abbr, at.* FROM tbl_attendance at 
            LEFT JOIN tbl_user u ON at.tbl_user_id = u.tbl_user_id 
            LEFT JOIN tbl_office o ON o.tbl_office_id = at.tbl_office_id
            where u.tbl_user_id = ANY($1)
            ORDER BY at.tbl_attendance_id DESC;`, [userIds]);

        const attendanceData = result.rows.map((table) => {
            // Parse check-in and check-out times
            const checkInTime = moment(table.check_in_time);
            const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

            // Calculate working time
            const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';

            return {
                tbl_attendance_id: table.tbl_attendance_id,
                tbl_user_id: table.tbl_user_id,
                office_name: table.office_name,
                full_name: table.full_name,
                designation_abbr: table.designation_abbr,
                // day_number: moment(table.created_date).format('DD'),
                // day_name: moment(table.created_date).format('ddd'),
                created_date: table.created_date,
                check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                working_time: workingTime,
            };
        });  

        res.render('user_atendence_list', {
            layout: true,
            attendance_data: attendanceData,
            pagetitle: 'atendnce_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

///////////////////////////////////// atendnce code end here ///////////////////////

/////////////////////////   wealthyfy code start from here   /////////////////// 

///////////////////////////////////// admin Code start from here //////////////////////

app.get('/user_list', auth, async (req, res) => {

    try {
        // const md_user_id = '2';
        const md_user_id = req.session.supadminid;

        ///////////// get team id code start from here ////////////////////////////////
          const recursivequery = `
          WITH RECURSIVE RecursiveCTE AS (
          SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_parent_id = $1

          UNION ALL

          SELECT t.tbl_user_id, t.tbl_parent_id 
          FROM tbl_user_connection t 
          INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
          )
          SELECT tbl_user_id FROM RecursiveCTE;
      `;
      const childUsersResult = await pool.query(recursivequery, [md_user_id]);
      userIds = childUsersResult.rows.map(row => row.tbl_user_id);

    //   console.log('userIds', userIds);
      
      ///////////// get team id code start from here ////////////////////////////////


        const result = await pool.query(`SELECT (SELECT office_name FROM tbl_office where tbl_office_id = tbl_user.tbl_office_id), tbl_user.* FROM tbl_user where tbl_user_id = ANY($1) AND status != 5 order by tbl_user_id DESC`, [userIds]);
        const usr_data = result.rows;
        
        res.render('user_list', {
            layout: true,
            usr_data: usr_data,
            pagetitle: 'user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/edit_user/:user_id', auth, async (req, res) => {
    try {
    
        const result = await pool.query(`SELECT * FROM tbl_user where tbl_user_id = '${req.params.user_id}' AND status != 5`);
        const user_data = result.rows;

        const designation_query = await pool.query(`SELECT * FROM tbl_designation where status = 1 order by tbl_designation_id ASC`);
        const designtion_data = designation_query.rows;

        const office_query = await pool.query(`SELECT * FROM tbl_office where status = 1 order by tbl_office_id ASC`);
        const office_data = office_query.rows;       
            
        res.render('user_detail', {
            layout : true,
            user_data : user_data,
            designtion_data : designtion_data,
            office_data : office_data,
            pagetitle : 'user_page'
        });
       
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/view_user_detail/:user_id/:pageurl?', auth, async (req, res) => {
    try {
        const userId = req.params.user_id;
        
        // Initiate all queries concurrently
        const [storePromise, meetingRes,  leavRes, atendencRes] = [
            pool.query(`SELECT (SELECT office_name FROM tbl_office where tbl_office_id = tbl_user.tbl_office_id), tbl_user.* FROM tbl_user where tbl_user_id = '${userId}' AND status != 5`),

            pool.query(`SELECT ua.full_name AS approved_by_user_name, tm.*  FROM  tbl_meeting tm LEFT JOIN tbl_user ua ON tm.approved_reject_by_user_id = ua.tbl_user_id where tm.tbl_user_id = '${userId}'`),

            pool.query(`SELECT ua.full_name AS approved_by_user_name, ul.* FROM tbl_user_leave ul LEFT JOIN tbl_user ua ON ul.leave_approved_reject_by_user_id = ua.tbl_user_id where ul.tbl_user_id = $1`, [userId]),

            pool.query(`SELECT * FROM tbl_attendance WHERE tbl_user_id = '${userId}' ORDER BY tbl_attendance_id DESC`)
            
        ];
        // Wait for all promises to resolve
        const [result, meetingResult, leavResult, atendencResult ] = await Promise.all([storePromise, meetingRes, leavRes, atendencRes]);

        if(result.rowCount > 0){

            const attendanceData = atendencResult.rows.map((table) => {
                // Parse check-in and check-out times
                const checkInTime = moment(table.check_in_time);
                const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

                // Calculate working time
                const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';

                return {
                    tbl_attendance_id: table.tbl_attendance_id,
                    tbl_user_id: table.tbl_user_id,                    
                    // day_number: moment(table.created_date).format('DD'),
                    // day_name: moment(table.created_date).format('ddd'),
                    created_date: table.created_date,
                    check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                    check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                    working_time: workingTime,
                };
            });           

            res.render('view_user', {
                layout: true,
                pageurl: req.params.pageurl,
                user_data: result.rows,
                meting_data: meetingResult.rows,
                leave_data: leavResult.rows,
                attendance_data: attendanceData,
                pagetitle: 'user_page'
            });
        }else{
            res.redirect('/error_page');
        }

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

// app.post('/user_update', auth, function (req, res) {

//     var form = new formidable.IncomingForm();
//     form.keepExtensions = true;
//     form.parse(req, function (err, fields, files) {

//         var FormData = require('form-data');
//         var fs = require('fs');
//         var data = new FormData();

     
//         const dgnation_data = fields.designation_data.toString().split(',');
//         const designation_id = dgnation_data[0];
//         const designation_abbr = dgnation_data[1];

//         data.append('tbl_user_id', fields.tbl_user_id);
//         data.append('emp_id', fields.user_empId);
//         data.append('tbl_designation_id', designation_id);
//         data.append('designation_abbr', designation_abbr);
//         data.append('tbl_office_id', fields.office_id);
//         data.append('email', fields.email);
//         data.append('full_name', fields.full_name);
//         data.append('mobile', fields.mobile);
//         data.append('password', fields.pswd);
//         data.append('user_latitude', fields.user_lat);
//         data.append('user_longitude', fields.user_long);
//         data.append('user_city', fields.city);
//         data.append('user_state', fields.state);
//         data.append('status', fields.status);
        
//         if(files.user_image != undefined){
//             if (files.user_image.size > 0) {
//                 data.append('user_image', fs.createReadStream(files.user_image.path));
//                const userextnxn_typ =  files.user_image.type.split('/').pop();  
//                 if (["png", "jpg", "jpeg"].includes(userextnxn_typ)) {
//                     data.append('user_image_extn', userextnxn_typ);
//                 } else {
//                     return res.status(201).json({ status: false, message: "Please select a valid image (PNG, JPG, JPEG).", });
//                 }
//             } else {
//                 console.log('user_image nhi hai');
//             } 
//         }else{
//             console.log('user_image files is undefined');
//         }


//         var config = {
//             method: 'post',
//             url: apiurl +  '/admin_user_data/update_user_details_API',
//             headers: {
//                 // 'Authorization': 'Bearer ' + req.session.token,
//                 ...data.getHeaders()
//             },
//             data: data
//         };        

//         axios(config)
//         .then((user_updt_res) => {
           

//             var sts = user_updt_res.data.status;
//             var msg = user_updt_res.data.message;
            
//             if (sts == false) {
//                 res.status(201).json({ status: false, message: msg, });
//             } else {
//                 res.status(201).json({ status: true, message: msg, });
//             }
//         })
//         .catch(function (error) {
//             console.log(error);
//         });
//     });
// });

// app.get('/add_user', auth, async (req, res) => {

//     const designation_query = await pool.query(`SELECT * FROM tbl_designation where status = 1 order by tbl_designation_id ASC`);
//     const designtion_data = designation_query.rows;

//     const office_query = await pool.query(`SELECT * FROM tbl_office where status = 1 order by tbl_office_id ASC`);
//     const office_data = office_query.rows;

//     try {
//         res.render('add_user', {
//             designtion_data : designtion_data,
//             office_data : office_data,
//             layout: true,
//             pagetitle : 'user_page'
//         });
//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });


// app.post('/user_add', function (req, res) {

//     var form = new formidable.IncomingForm();
//     form.keepExtensions = true;
//     form.parse(req, function (err, fields, files) {

//         var FormData = require('form-data');
//         var fs = require('fs');
//         var data = new FormData();

     
//         const dgnation_data = fields.designation_data.toString().split(',');
//         const designation_id = dgnation_data[0];
//         const designation_abbr = dgnation_data[1];
  
//         data.append('emp_id', fields.user_empId);
//         data.append('tbl_designation_id', designation_id);
//         data.append('designation_abbr', designation_abbr);
//         data.append('tbl_office_id', fields.office_id);
//         data.append('email', fields.email);
//         data.append('full_name', fields.full_name);
//         data.append('mobile', fields.mobile);
//         data.append('password', fields.pswd);
//         data.append('user_latitude', fields.user_lat);
//         data.append('user_longitude', fields.user_long);
//         data.append('user_city', fields.city);
//         data.append('user_state', fields.state);
        
//         if(files.user_image != undefined){
//             if (files.user_image.size > 0) {
//                 data.append('user_image', fs.createReadStream(files.user_image.path));
//                const userextnxn_typ =  files.user_image.type.split('/').pop();  
//                 if (["png", "jpg", "jpeg"].includes(userextnxn_typ)) {
//                     data.append('user_image_extn', userextnxn_typ);
//                 } else {
//                     return res.status(201).json({ status: false, message: "Please select a valid image (PNG, JPG, JPEG).", });
//                 }
//             } else {
//                 console.log('user_image nhi hai');
//             } 
//         }else{
//             console.log('user_image files is undefined');
//         }


//         var config = {
//             method: 'post',
//             url: apiurl +  '/admin_user_data/create_user_by_admin_API',
//             headers: {
//                 // 'Authorization': 'Bearer ' + req.session.token,
//                 ...data.getHeaders()
//             },
//             data: data
//         };        

//         axios(config)
//         .then((user_add_res) => {
          

//             var sts = user_add_res.data.status;
//             var msg = user_add_res.data.message;
            
//             if (sts == false) {
//                 res.status(201).json({ status: false, message: msg, });
//             } else {
//                 res.status(201).json({ status: true, message: msg, });
//             }
//         })
//         .catch(function (error) {
//             console.log(error);
//         });
//     });
// });


///////////////////////////////////// User Code end here //////////////////////

///////////////////////////////////// Office start from here //////////////////////

app.get('/office_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_office order by tbl_office_id DESC`);
        const ofic_data = result.rows;
        res.render('office_list', {
            layout: true,
            ofic_data: ofic_data,
            pagetitle: 'ofic_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/office_details/:offic_id', auth, async (req, res) => {

    try {
        const { offic_id } = req.params;
    
        const result = await pool.query(`SELECT * FROM tbl_office where tbl_office_id = '${offic_id}'`);
        const ofic_data = result.rows;
        
        res.render('office_detail', {
            layout: true,
            ofice_data: ofic_data,
            pagetitle: 'ofic_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

///////////////////////////////////// Office code end here //////////////////////

////////////////////////////////// md view team code start from here //////////////////
app.get('/md_view_team', auth, async (req, res) => {

    // const { md_user_id } = req.params;

    // const md_user_id = '2';
    const md_user_id = req.session.supadminid;

    try {
        // Fetch MD details
        const mdResult = await pool.query(
            `SELECT tbl_user_id, full_name, designation_abbr FROM tbl_user WHERE tbl_user_id = $1 AND designation_abbr = 'MD'`,
            [md_user_id]
        );

        if (mdResult.rows.length === 0) {
            return res.status(404).send("MD not found.");
        }

        const mdData = mdResult.rows[0];

        // Fetch all child users under MD recursively
        const childUsersResult = await pool.query(
            `WITH RECURSIVE RecursiveCTE AS (
                SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                UNION ALL
                SELECT t.tbl_user_id, t.tbl_parent_id FROM tbl_user_connection t 
                INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
            )
            SELECT u.tbl_user_id, u.full_name, u.designation_abbr, c.tbl_parent_id
            FROM RecursiveCTE c
            JOIN tbl_user u ON u.tbl_user_id = c.tbl_user_id
            ORDER BY c.tbl_parent_id, u.tbl_user_id;`,
            [md_user_id]
        );

        // Function to build a hierarchical tree
        function buildTree(users, parentId) {
            return users
                .filter(user => user.tbl_parent_id == parentId)
                .map(user => ({
                    ...user,
                    children: buildTree(users, user.tbl_user_id)
                }));
        }

        const teamTree = buildTree(childUsersResult.rows, mdData.tbl_user_id);

        // Function to generate HTML recursively
        function generateTreeHTML(users) {
            if (!users.length) return '';
            let html = '<ul>';
            users.forEach(user => {
                html += `
                    <li class="${user.designation_abbr.toLowerCase()}">
                        ${user.full_name} (${user.designation_abbr})
                        ${generateTreeHTML(user.children)}
                    </li>
                `;
            });
            html += '</ul>';
            return html;
        }

        const teamTreeHTML = generateTreeHTML(teamTree);

        res.render('md_view_team', {
            layout : true,
            md_data: mdData,  
            team_tree_html: teamTreeHTML,  
            pagetitle: 'md_user_page'
        });
    } catch (error) {
        console.error('Error fetching team data:', error);
        res.status(500).send('Error fetching team data');
    }
});
////////////////////////////// md view team code end here ///////////////////////////

///////////////////////////////// admin Code end here //////////////////////


/////////////////////////////////  👍👍👍👌👌👍👌👌👌👌👌👌👍👌👌👌 /////////////////////////

app.get('/error_page', auth, function (req, res) {
    res.status(404).render('404_page', {
        pagetitle: ''
    })
})

app.get('*', auth, function (req, res) {
    res.status(404).render('404_page', {
        pagetitle: ''
    })
})

app.listen(8114);
console.log('8114 is the magic port');