const pg = require('pg');
const fs = require('fs');
const nodeMailer = require('nodemailer')
const formidable = require('formidable');
const moment = require('moment');
const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);
const { base_img_url } = require('../wealthyfy_api_index');
const { haversineDistance } = require('./haversine');
const all_user_notification = require('./all_user_notification_function');

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

function isNUM(item) {
    if (item) {
        return item;
    } else {
        return 0;
    }
}

const transporter = nodeMailer.createTransport({
    host: 'smtp.gmail.com',
    port: 587,
    secure: false,
    auth: {
        user: 'aws.addcrypto@gmail.com',
        pass: 'tnafkiklxtbdsopq'
    }
});

module.exports = {



    create_meeting_api: async (req, res) => {
        try {
            const {
                tbl_office_id, tbl_user_id, client_id, client_name, client_email, client_mobile,
                city, state, country, meeting_latitude, meeting_longitude, family_details,
                stock_portfolio_with_us, stock_portfolio_with_other_broker, pms,
                mutual_fund_portfolio, fixed_deposite, loan_details, insurance,
                reference_1, reference_2, remark, full_address
            } = req.body;
    
            // Ensure optional parameters are not undefined
            const sanitizeInput = (input) => input || '';
            const stockportfoliowithus = sanitizeInput(stock_portfolio_with_us);
            const stockportfoliowithother_broker = sanitizeInput(stock_portfolio_with_other_broker);
            const familydetails = sanitizeInput(family_details);
            const reference1 = sanitizeInput(reference_1);
            const reference2 = sanitizeInput(reference_2);
            const pms1 = sanitizeInput(pms);
            const remark1 = sanitizeInput(remark);
    
            // Validate user existence
            const userQuery = await pool.query(
                `SELECT tbl_user_id, full_name, designation_abbr FROM tbl_user WHERE tbl_user_id = $1 AND status = '1'`,
                [tbl_user_id]
            );
    
            if (userQuery.rowCount === 0) {
                return res.status(404).json({ status: false, message: 'User not found' });
            }
    
            // Insert meeting data
            const insertMeetingQuery = `
                INSERT INTO tbl_meeting (
                    tbl_office_id, tbl_user_id, client_id, client_name, client_email,
                    client_mobile, city, state, country, meeting_latitude, meeting_longitude,
                    family_details, stock_portfolio_with_us, stock_portfolio_with_other_broker,
                    mutual_fund_portfolio, fixed_deposite, loan_details, insurance, pms, ncd,
                    reference_1, reference_2, remark, full_address
                ) VALUES (
                    $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, 'no', $20, $21, $22, $23
                ) RETURNING tbl_meeting_id;
            `;
    
            const meetingInsertResult = await pool.query(insertMeetingQuery, [
                tbl_office_id, tbl_user_id, client_id, client_name, client_email,
                client_mobile, city, state, country, meeting_latitude, meeting_longitude,
                familydetails, stockportfoliowithus, stockportfoliowithother_broker,
                mutual_fund_portfolio, fixed_deposite, loan_details, insurance, pms1,
                reference1, reference2, remark1, full_address
            ]);
    
            if (meetingInsertResult.rowCount === 0) {
                return res.status(500).json({ status: false, message: 'Failed to create meeting.' });
            }
    
            // Fetch parent user IDs
            const recursiveParentQuery = `
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE tbl_user_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id, t.tbl_parent_id 
                    FROM tbl_user_connection t 
                    INNER JOIN RecursiveCTE r ON r.tbl_parent_id = t.tbl_user_id
                )
                SELECT tbl_parent_id FROM RecursiveCTE;
            `;
    
            const ParentUserResult = await pool.query(recursiveParentQuery, [tbl_user_id]);
            const parentIds = ParentUserResult.rows.map(row => row.tbl_parent_id);
    
            if (parentIds.length > 0) {
                const parentQuery = await pool.query(
                    `SELECT tbl_user_id as parentid, firebase_tokens as parent_firebasetoken FROM tbl_user WHERE tbl_user_id = ANY($1)`,
                    [parentIds]
                );
    
                if (parentQuery.rowCount > 0) {
                    const notificationPromises = parentQuery.rows.map(async (table) => {
                        const firebase_token = table.parent_firebasetoken;
                        if (!firebase_token || firebase_token === 'firebase_token') {
                            console.warn(`Skipping invalid token: ${firebase_token}`);
                            return null;
                        }
    
                        console.log(`Sending notification to parent token: ${firebase_token}`);
                        return all_user_notification.send_notification_to_user_by_firebase_token(
                            'New Meeting Request',
                            `New meeting request is generated by ${userQuery.rows[0].full_name} (${userQuery.rows[0].designation_abbr})`,
                            'meeting', 'user', tbl_user_id, firebase_token,
                            meetingInsertResult.rows[0].tbl_meeting_id, table.parentid
                        );
                    });
    
                    await Promise.all(notificationPromises.filter(p => p !== null));
                } else {
                    console.log('No valid parent users found for notifications.');
                }
            }
    
            return res.status(201).json({ status: true, message: 'Meeting is created successfully.' });
        } catch (err) {
            console.error('Error in create meeting API:', err);
            return res.status(500).json({ status: false, message: 'Error occurred while creating meeting.' });
        }
    },
    

    // create_meeting_api: async (req, res) => {

    //     const { tbl_office_id, tbl_user_id, client_id, client_name, client_email, client_mobile, city, state, country, meeting_latitude, meeting_longitude,  family_details, stock_portfolio_with_us, stock_portfolio_with_other_broker,  pms, mutual_fund_portfolio, fixed_deposite, loan_details, insurance, reference_1, reference_2, remark, full_address } = req.body;

    //     // optinal parameters
       
    //     if (stock_portfolio_with_us == '' || stock_portfolio_with_us == null || stock_portfolio_with_us == undefined) {
    //         var stockportfoliowithus = ''
    //     } else {
    //         var stockportfoliowithus = stock_portfolio_with_us;
    //     }
    //     if (stock_portfolio_with_other_broker == '' || stock_portfolio_with_other_broker == null || stock_portfolio_with_other_broker == undefined) {
    //         var stockportfoliowithother_broker = ''
    //     } else {
    //         var stockportfoliowithother_broker = stock_portfolio_with_other_broker;
    //     }
    //     if (family_details == '' || family_details == null || family_details == undefined) {
    //         var familydetails = ''
    //     } else {
    //         var familydetails = family_details;
    //     }
    //     if (reference_1 == '' || reference_1 == null || reference_1 == undefined) {
    //         var reference1 = ''
    //     } else {
    //         var reference1 = reference_1;
    //     }
    //     if (pms == '' || pms == null || pms == undefined) {
    //         var pms1 = ''
    //     } else {
    //         var pms1 = pms;
    //     }
    //     if (reference_2 == '' || reference_2 == null || reference_2 == undefined) {
    //         var reference2 = ''
    //     } else {
    //         var reference2 = reference_2;
    //     }
    //     if (remark == '' || remark == null || remark == undefined) {
    //         var remark1 = ''
    //     } else {
    //         var remark1 = remark;
    //     }

    //     const userQuery = await pool.query(`SELECT tbl_user_id, full_name, designation_abbr from tbl_user where tbl_user_id = '${tbl_user_id}' and status = '1'`);

    //     if (userQuery.rowCount > 0) {

    //         // Insert meeting data into tbl_meeting
    //         const insertMeetingQuery = `
    //             INSERT INTO tbl_meeting (
    //                 tbl_office_id, tbl_user_id, client_id, client_name, client_email, 
    //                 client_mobile, city, state, country, meeting_latitude, meeting_longitude, family_details, 
    //                 stock_portfolio_with_us, stock_portfolio_with_other_broker, mutual_fund_portfolio, 
    //                 fixed_deposite, loan_details, insurance, pms, ncd, reference_1, reference_2, remark, full_address
    //             ) 
    //             VALUES (
    //                 '${tbl_office_id}', '${tbl_user_id}', '${client_id}', $$${client_name}$$, '${client_email}',
    //                 '${client_mobile}', '${city}', '${state}', '${country}', '${meeting_latitude}', '${meeting_longitude}', $$${familydetails}$$, '${stockportfoliowithus}', '${stockportfoliowithother_broker}',  '${mutual_fund_portfolio}', 
    //                 '${fixed_deposite}', '${loan_details}', '${insurance}', '${pms1}', 'no', $$${reference1}$$, $$${reference2}$$, $$${remark1}$$, $$${full_address}$$
                    
    //             )RETURNING tbl_meeting_id`;
    //         try {
    //             const meetingInsertResult = await pool.query(insertMeetingQuery);

    //             if (meetingInsertResult.rowCount > 0) {

    //                 //////////////////////// this code is integrate for notification of this user parent //////////

    //                   // Recursive query to fetch all parent user IDs
    //                     const recursiveParentQuery = `
    //                     WITH RECURSIVE RecursiveCTE AS (
    //                       SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_user_id = $1
    //                       UNION ALL
    //                       SELECT t.tbl_user_id, t.tbl_parent_id 
    //                       FROM tbl_user_connection t 
    //                       INNER JOIN RecursiveCTE r ON r.tbl_parent_id = t.tbl_user_id
    //                     )
    //                     SELECT tbl_parent_id FROM RecursiveCTE;
    //                 `;

    //                 const ParentUserResult = await pool.query(recursiveParentQuery, [tbl_user_id]);                  
    //                 const parentIds = ParentUserResult.rows.map(row => row.tbl_parent_id);

    //                 const parentQuery = await pool.query(`SELECT tbl_user_id as parentid, firebase_tokens as parent_firebasetoken FROM tbl_user WHERE tbl_user_id = ANY($1) ORDER BY tbl_user_id DESC`, [parentIds] );

    //                 if (parentQuery.rowCount > 0) {
    //                     const notificationPromises = parentQuery.rows.map(async (table) => {
    //                         const title = `New Meeting request`;
    //                         const notification_type = 'meeting';
    //                         const notification_message = `New meeting request is generated by ${userQuery.rows[0].full_name} (${userQuery.rows[0].designation_abbr})`;
    //                         const firebase_token = table.parent_firebasetoken;
    //                         const meeting_leave_id = meetingInsertResult.rows[0].tbl_meeting_id;
    //                         const parent_id = table.parentid;

    //                         console.log(`Sending notification to parent token: ${firebase_token}`);

    //                         return all_user_notification.send_notification_to_user_by_firebase_token(
    //                             title, notification_message, notification_type, 'user', tbl_user_id, firebase_token, meeting_leave_id, parent_id
    //                         );
    //                     });

    //                     await Promise.all(notificationPromises);
    //                 } else {
    //                     console.log('Parent user not found for this user.');
    //                 }
                    
    //             //////////////////////// this code is integrate for notification of this user parent //////////


    //                 return res.status(201).json({ status: true, message: 'Meeting is created successfully.' });
    //             } else {
    //                 return res.status(500).json({ status: false, message: 'Failed to create meeting.' });
    //             }
    //         } catch (err) {
    //             console.error(err);
    //             return res.status(500).json({ status: false, message: 'Error occurred while creating meeting.' });
    //         }
    //     } else {
    //         return res.status(404).json({ status: false, message: 'User not found' });
    //     }
    // },

    edit_meeting_api: async (req, res) => {

        const { tbl_meeting_id, tbl_user_id, client_id, client_name, client_email, client_mobile, city, state, country, meeting_latitude, meeting_longitude, family_details, stock_portfolio_with_us, stock_portfolio_with_other_broker, mutual_fund_portfolio, fixed_deposite, loan_details, insurance, pms, reference_1, reference_2, remark, full_address } = req.body;

        // optinal parameters
        
        if (stock_portfolio_with_us == '' || stock_portfolio_with_us == null || stock_portfolio_with_us == undefined) {
            var stockportfoliowithus = ''
        } else {
            var stockportfoliowithus = stock_portfolio_with_us;
        }
        if (stock_portfolio_with_other_broker == '' || stock_portfolio_with_other_broker == null || stock_portfolio_with_other_broker == undefined) {
            var stockportfoliowithother_broker = ''
        } else {
            var stockportfoliowithother_broker = stock_portfolio_with_other_broker;
        }
        if (family_details == '' || family_details == null || family_details == undefined) {
            var familydetails = ''
        } else {
            var familydetails = family_details;
        }
        if (reference_1 == '' || reference_1 == null || reference_1 == undefined) {
            var reference1 = ''
        } else {
            var reference1 = reference_1;
        }
        if (pms == '' || pms == null || pms == undefined) {
            var pms1 = ''
        } else {
            var pms1 = pms;
        }
        if (reference_2 == '' || reference_2 == null || reference_2 == undefined) {
            var reference2 = ''
        } else {
            var reference2 = reference_2;
        }
        if (remark == '' || remark == null || remark == undefined) {
            var remark1 = ''
        } else {
            var remark1 = remark;
        }

        const userQuery = await pool.query(`SELECT tbl_user_id from tbl_user where tbl_user_id = '${tbl_user_id}' AND status = '1'`);

        if (userQuery.rowCount > 0) {
            const ckmetingQuery = await pool.query(`SELECT tbl_user_id, tbl_meeting_id, meeting_status from tbl_meeting where tbl_meeting_id = '${tbl_meeting_id}' AND tbl_user_id = '${tbl_user_id}'`);

            if (ckmetingQuery.rowCount > 0) {

                if (ckmetingQuery.rows[0].meeting_status == 'rejected' || ckmetingQuery.rows[0].meeting_status == 'approved') {
                    return res.status(500).json({ status: false, message: `This meeting is ${ckmetingQuery.rows[0].meeting_status}, so you can't modify it.`});

                } else {

                    /// update meeting details query

                    const updtmrting_query = `UPDATE tbl_meeting SET client_id = '${client_id}', client_name = $$${client_name}$$, client_email = '${client_email}',client_mobile = '${client_mobile}',city = '${city}',state = '${state}', country = '${country}', meeting_latitude = '${meeting_latitude}', meeting_longitude = '${meeting_longitude}',  family_details =  $$${familydetails}$$,   stock_portfolio_with_us = '${stockportfoliowithus}', stock_portfolio_with_other_broker = '${stockportfoliowithother_broker}',  mutual_fund_portfolio = '${mutual_fund_portfolio}', fixed_deposite = '${fixed_deposite}', loan_details = '${loan_details}', insurance = '${insurance}', pms = '${pms1}',  ncd = 'no',  reference_1 = $$${reference1}$$, reference_2 = $$${reference2}$$, remark =$$${remark1}$$, full_address =$$${full_address}$$ where tbl_meeting_id = '${tbl_meeting_id}' AND tbl_user_id = '${tbl_user_id}'`;

                    try {
                        const meetingupdtResult = await pool.query(updtmrting_query);
                        if (meetingupdtResult.rowCount > 0) {
                            return res.status(201).json({ status: true, message: 'Meeting updated successfully.' });
                        } else {
                            return res.status(500).json({ status: false, message: 'Failed to update meeting.' });
                        }
                    } catch (err) {
                        console.error(err);
                        return res.status(500).json({ status: false, message: 'Error occurred while updating meeting.' });
                    }
                }
            } else {
                return res.status(404).json({ status: false, message: 'meeting_id is wrong of this user.' });
            }
        } else {
            return res.status(404).json({ status: false, message: 'User not found' });
        }
    },

    meeting_reject_approved_api: async (req, res) => {

        const { tbl_meeting_id, tbl_user_id, tbl_office_id, meeting_status, approved_reject_by_user_id, approved_reject_by_user_type, reason } = req.body;

        if (reason == '' || reason == null || reason == undefined) {
            var reason1 = ''
        } else {
            var reason1 = reason;
        }

        const userQuery = await pool.query(`SELECT tbl_user_id, firebase_tokens as user_firebasetoken from tbl_user where tbl_user_id = '${tbl_user_id}' AND status = '1'`);

        if (userQuery.rowCount > 0) {
            const ckmetingQuery = await pool.query(`SELECT (SELECT full_name from tbl_user where tbl_user_id = '${approved_reject_by_user_id}' AND status = '1') AS head_user_fullname, tbl_user_id, tbl_meeting_id, meeting_status from tbl_meeting where tbl_meeting_id = '${tbl_meeting_id}' AND tbl_user_id = '${tbl_user_id}'`);

            if (ckmetingQuery.rowCount > 0) {

                if (ckmetingQuery.rows[0].meeting_status == 'rejected' || ckmetingQuery.rows[0].meeting_status == 'approved') {
                    return res.status(500).json({ status: false, message: `This meeting is already ${ckmetingQuery.rows[0].meeting_status}.` });

                } else {

                    /// update meeting details query 

                    const updtmrting_query = `UPDATE tbl_meeting SET meeting_status = '${meeting_status}', approved_reject_by_user_id = '${approved_reject_by_user_id}', approved_reject_by_user_type = $$${approved_reject_by_user_type}$$, approved_reject_by_user_date = now(), reason = $$${reason1}$$ where tbl_meeting_id = '${tbl_meeting_id}' AND tbl_user_id = '${tbl_user_id}' AND tbl_office_id = '${tbl_office_id}'`;

                    try {
                        const meetingupdtResult = await pool.query(updtmrting_query);
                        if (meetingupdtResult.rowCount > 0) {
                            //(title, notification_message, notification_type, send_type, tbl_user_id, firebase_token)

                            const title = `Meeting is ${meeting_status}`;
                            const notification_type = 'meeting'
                            const notification_message = `Your Meeting is ${meeting_status} by ${ckmetingQuery.rows[0].head_user_fullname} (${approved_reject_by_user_type})`;
                            const firebase_token = userQuery.rows[0].user_firebasetoken;
                            const meeting_leave_id = tbl_meeting_id;
                            const tbl_userid = approved_reject_by_user_id;
                            const parent_id = tbl_user_id;

                            console.log(`Sending notification to parent token: ${firebase_token}`);
                          
                            all_user_notification.send_notification_to_user_by_firebase_token(title, notification_message, notification_type, 'user', tbl_userid, firebase_token, meeting_leave_id, parent_id);

                            return res.status(201).json({ status: true, message: `Meeting ${meeting_status} successfully.` });
                        } else {
                            return res.status(500).json({ status: false, message: 'Failed to update meeting.' });
                        }
                    } catch (err) {
                        console.error(err);
                        return res.status(500).json({ status: false, message: 'Error occurred while updating meeting.' });
                    }
                }
            } else {
                return res.status(404).json({ status: false, message: 'meeting_id is wrong of this user.' });
            }
        } else {
            return res.status(404).json({ status: false, message: 'User not found' });
        }
    },

    user_meeting_list_api: async (req, res) => {

        const { tbl_user_id, type, status, designation_abbr, today, from_date, to_date, month_wise, year_wise } = req.body; // Input user ID and type ('my_meeting' or 'children')        

        if (status == '' || status == null || status == undefined) {
            var status1 = ''
        } else {
            var status1 = `AND m.meeting_status = '${status}'`;
        }

        if (designation_abbr == '' || designation_abbr == null || designation_abbr == undefined) {
            var designation_abbr1 = ``
        } else {
            var designation_abbr1 = `AND u.designation_abbr = '${designation_abbr}'`;
        }

        if (from_date == undefined || from_date == null || from_date == '')
        {
            var from_date1 = ``;
        }else{
            var from_date1 = `AND m.created_date >= '${from_date}'`;
        }
    
        if (to_date == undefined || to_date == null || to_date == '') 
        {
            var to_date1 = ``;
        }else{
            var to_date1 = `AND m.created_date <= '${to_date}'`;
        }

        if (today == undefined || today == null || today == '') 
        {
            var today1 = ``;
        }else{
            var today1 = `AND m.created_date = '${today}'`;
        }
        
        if (month_wise == undefined || month_wise == null || month_wise == '') 
        {
            var month_wise1 = ``;
        }else{
            var month_wise1 = `AND EXTRACT(MONTH FROM m.created_date) =  '${month_wise}'`;
        }

        if (year_wise == undefined || year_wise == null || year_wise == '')
        {
            var year_wise1 = ``;
        }else{
            var year_wise1 = `AND EXTRACT(YEAR FROM m.created_date) =  '${year_wise}'`;
        }

        try {
            // Step 1: Check if the given user ID exists and is active
            const userQuery = await pool.query(`SELECT tbl_user_id FROM tbl_user_connection WHERE tbl_user_id = $1 AND status = '1'`, [tbl_user_id]);

            if (userQuery.rowCount > 0) {
                let userIds = [];

                // Step 2: Determine the query logic based on 'type'
                if (type === 'my_meeting') {
                    var resmsg = 'My Meeting';
                    // Fetch only the current user's meetings
                    userIds = [tbl_user_id]; // Use only the provided user ID
                } else if (type === 'children') {
                    var resmsg = 'Children Meeting';
                    // Recursive query to fetch all child user IDs
                    const recursiveUserQuery = `
                        WITH RECURSIVE RecursiveCTE AS (
                            SELECT tbl_user_id, tbl_parent_id 
                            FROM tbl_user_connection 
                            WHERE tbl_parent_id = $1
        
                            UNION ALL

                            SELECT t.tbl_user_id, t.tbl_parent_id
                            FROM tbl_user_connection t
                            INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                        )
                        SELECT tbl_user_id FROM RecursiveCTE;
                    `;

                    const childUsersResult = await pool.query(recursiveUserQuery, [tbl_user_id]);
                    userIds = childUsersResult.rows.map(row => row.tbl_user_id);
                } else {
                    // Invalid type provided
                    return res.status(400).json({ status: false, message: 'Invalid type. Use "my_meeting" or "children".' });
                }

                // Step 3: Query to fetch meetings for the determined user IDs               

                const meetingQuery = await pool.query(`SELECT m.*, u.emp_id, u.full_name, u.designation_abbr FROM tbl_meeting m INNER JOIN tbl_user u ON m.tbl_user_id = u.tbl_user_id  WHERE m.tbl_user_id = ANY($1) ${designation_abbr1} ${from_date1} ${to_date1} ${today1} ${month_wise1} ${year_wise1} ${status1} ORDER BY m.tbl_meeting_id DESC`,
                    [userIds]
                );
            

                // Step 4: Process and format meeting data
                if (meetingQuery.rowCount > 0) {

                    const data = meetingQuery.rows.map((table) => ({

                        tbl_meeting_id: table.tbl_meeting_id,
                        tbl_user_id: table.tbl_user_id,
                        emp_id: table.emp_id,
                        full_name: isNull(table.full_name),
                        designation_abbr: isNull(table.designation_abbr),
                        tbl_office_id: table.tbl_office_id,
                        client_id: isNull(table.client_id),
                        client_name: isNull(table.client_name),
                        client_email: isNull(table.client_email),
                        client_mobile: isNull(table.client_mobile),
                        city: isNull(table.city),
                        state: isNull(table.state),
                        country: isNull(table.country),
                        full_address: isNull(table.full_address),
                        family_details: isNull(table.family_details),
                        stock_portfolio_with_us: isNull(table.stock_portfolio_with_us),
                        stock_portfolio_with_other_broker: isNull(table.stock_portfolio_with_other_broker),
                        mutual_fund_portfolio: isNull(table.mutual_fund_portfolio),
                        fixed_deposite: isNull(table.fixed_deposite),
                        loan_details: isNull(table.loan_details),
                        insurance: isNull(table.insurance),
                        pms: isNull(table.pms),
                        ncd: isNull(table.ncd),
                        reference_1: isNull(table.reference_1),
                        reference_2: isNull(table.reference_2),
                        remark: isNull(table.remark),
                        meeting_status: isNull(table.meeting_status),
                        meeting_date: moment(table.created_datetime).format('DD-MM-YYYY'),
                        meeting_time: moment(table.created_datetime).utcOffset("+05:30").format('hh:mm:ss A'),
                        meeting_check_in_status: isNUM(table.meeting_check_in_status),
                    }));

                    // Step 5: Return successful response
                    return res.status(200).json({ status: true, message: `${resmsg} list API`, data: data });
                } else {
                    // No meetings found
                    return res.status(200).json({ status: false, message: 'No meetings found.', data: [] });
                }
            } else {
                // User not found or inactive
                return res.status(404).json({ status: false, message: 'User not found or inactive.' });
            }
        } catch (error) {
            console.error('Error:', error.message);
            return res.status(500).json({ status: false, message: 'Server Error' });
        }
    },

    user_meeting_details_api: async (req, res) => {

        const { tbl_user_id, tbl_meeting_id } = req.body;

        const userQuery = await pool.query(`SELECT tbl_user_id from tbl_user where tbl_user_id = '${tbl_user_id}' and status = '1'`);

        if (userQuery.rowCount > 0) {

            const meetingQuery = await pool.query(`SELECT m.*, u.emp_id, u.full_name, u.designation_abbr FROM tbl_meeting m INNER JOIN tbl_user u ON m.tbl_user_id = u.tbl_user_id where m.tbl_meeting_id =  '${tbl_meeting_id}'`);
            // const meetingQuery = await pool.query(`SELECT * from tbl_meeting where tbl_meeting_id =  '${tbl_meeting_id}'`);

            if (meetingQuery.rowCount > 0){

                const result_row = meetingQuery.rows;

                var data = [];

                result_row.forEach((table) => {

                    let meetdata = {

                        tbl_meeting_id: table.tbl_meeting_id,
                        tbl_user_id: table.tbl_user_id,
                        emp_id: table.emp_id,
                        full_name: isNull(table.full_name),
                        designation_abbr: isNull(table.designation_abbr),
                        tbl_office_id: table.tbl_office_id,
                        client_id: isNull(table.client_id),
                        client_name: isNull(table.client_name),
                        client_email: isNull(table.client_email),
                        client_mobile: isNull(table.client_mobile),
                        city: isNull(table.city),
                        state: isNull(table.state),
                        country: isNull(table.country),
                        full_address: isNull(table.full_address),
                        family_details: isNull(table.family_details),
                        stock_portfolio_with_us: isNull(table.stock_portfolio_with_us),
                        stock_portfolio_with_other_broker: isNull(table.stock_portfolio_with_other_broker),
                        mutual_fund_portfolio: isNull(table.mutual_fund_portfolio),
                        fixed_deposite: isNull(table.fixed_deposite),
                        loan_details: isNull(table.loan_details),
                        insurance: isNull(table.insurance),
                        pms: isNull(table.pms),
                        ncd: isNull(table.ncd),
                        reference_1: isNull(table.reference_1),
                        reference_2: isNull(table.reference_2),
                        remark: isNull(table.remark),
                        meeting_status: isNull(table.meeting_status),
                        meeting_date: moment(table.created_datetime).format('DD-MM-YYYY'),
                        meeting_time: moment(table.created_datetime).utcOffset("+05:30").format('hh:mm:ss A'),
                        meeting_check_in_status: isNUM(table.meeting_check_in_status),
                    }
                    data.push(meetdata);
                });

                return res.status(201).json({ status: true, message: 'Meeting Details API', data: data });
            } else {
                return res.status(201).json({ status: false, message: 'Meeting not found.', data: [] });
            }
        } else {
            return res.status(404).json({ status: false, message: 'User not found' });
        }
    },

    user_dashboard_approved_meeting_api: async (req, res) => {

        const { tbl_user_id } = req.body;

        const userQuery = await pool.query(`SELECT tbl_user_id from tbl_user where tbl_user_id = '${tbl_user_id}' and status = '1'`);

        if (userQuery.rowCount > 0) {

            const meetingQuery = await pool.query(`SELECT (SELECT full_name from tbl_user where tbl_user_id = tbl_meeting.approved_reject_by_user_id) AS approved_reject_by_user_name,  tbl_meeting.* from tbl_meeting where tbl_user_id = '${tbl_user_id}' and meeting_status = 'approved' order by tbl_meeting_id desc limit 5`);

            if (meetingQuery.rowCount > 0){

                const result_row = meetingQuery.rows;

                var data = [];

                result_row.forEach((table) => {

                    let meetdata = {

                        tbl_meeting_id: table.tbl_meeting_id,
                        tbl_user_id: table.tbl_user_id,
                        tbl_office_id: table.tbl_office_id,
                        client_id: isNull(table.client_id),
                        client_name: isNull(table.client_name),
                        client_email: isNull(table.client_email),
                        client_mobile: isNull(table.client_mobile),
                        city: isNull(table.city),
                        state: isNull(table.state),
                        country: isNull(table.country),
                        full_address: isNull(table.full_address),
                        family_details: isNull(table.family_details),
                        stock_portfolio_with_us: isNull(table.stock_portfolio_with_us),
                        stock_portfolio_with_other_broker: isNull(table.stock_portfolio_with_other_broker),
                        mutual_fund_portfolio: isNull(table.mutual_fund_portfolio),
                        fixed_deposite: isNull(table.fixed_deposite),
                        loan_details: isNull(table.loan_details),
                        insurance: isNull(table.insurance),
                        pms: isNull(table.pms),
                        ncd: isNull(table.ncd),
                        reference_1: isNull(table.reference_1),
                        reference_2: isNull(table.reference_2),
                        remark: isNull(table.remark),
                        meeting_status: isNull(table.meeting_status),
                        meeting_date: moment(table.created_datetime).format('DD-MM-YYYY'),
                        meeting_time: moment(table.created_datetime).utcOffset("+05:30").format('hh:mm:ss A'),

                        meeting_check_in_status: isNUM(table.meeting_check_in_status),
                        approved_by_user_id: isNUM(table.approved_reject_by_user_id),
                        approved_by_user_name: isNull(table.approved_reject_by_user_name),
                        approved_by_user_type: isNull(table.approved_reject_by_user_type),
                        approved_by_user_date: moment(table.approved_reject_by_user_date).format('DD-MM-YYYY'),
                        approved_by_user_time: moment(table.approved_reject_by_user_date).utcOffset("+05:30").format('hh:mm:ss A'),
                    }
                    data.push(meetdata);
                });

                return res.status(201).json({ status: true, message: 'User dashboard meeting approved API', data: data });
            } else {
                return res.status(201).json({ status: false, message: 'Meeting not found.', data: [] });
            }
        } else {
            return res.status(404).json({ status: false, message: 'User not found' });
        }
    },

    meeting_check_in_api: async (req, res) => {

        const { tbl_meeting_id, tbl_user_id, tbl_office_id, meeting_check_in_latitude, meeting_check_in_longitude, meeting_check_in_city, meeting_check_in_full_address } = req.body;

        if(meeting_check_in_full_address == '' || meeting_check_in_full_address == null || meeting_check_in_full_address == undefined){
            var checkin_full_address = '';
        }else{
            var checkin_full_address = meeting_check_in_full_address;
        }

        const userQuery = await pool.query(`SELECT tbl_user_id from tbl_user where tbl_user_id = '${tbl_user_id}' AND status = '1'`);

        if (userQuery.rowCount > 0) {
            const ckmetingQuery = await pool.query(`SELECT tbl_user_id, tbl_meeting_id, meeting_status, meeting_latitude, meeting_longitude, city, meeting_check_in_status from tbl_meeting where tbl_meeting_id = '${tbl_meeting_id}' AND tbl_user_id = '${tbl_user_id}'`);

            if (ckmetingQuery.rowCount > 0) {

                if (ckmetingQuery.rows[0].meeting_status == 'approved'){

                    if(ckmetingQuery.rows[0].meeting_check_in_status == 'yes') {
                        return res.status(201).json({ status: true, message: `You have already check in this meeting.`});
                    }

                    /// update meeting details query

                    const meeting_latitude = parseFloat(ckmetingQuery.rows[0].meeting_latitude);
                    const meeting_longitude = parseFloat(ckmetingQuery.rows[0].meeting_longitude);
                    const city = ckmetingQuery.rows[0].city;
                
                    
                    // Calculate the distance
                    const distance = haversineDistance(
                        parseFloat(meeting_check_in_latitude),
                        parseFloat(meeting_check_in_longitude),
                        meeting_latitude,
                        meeting_longitude
                    );
            
                    // Check if within 100 meters
                    // if (distance > 100) {
                    //     return res.status(201).json({ 
                    //         status: false, 
                    //         message: 'Check-in denied. You are not within 100 meters of the meeting area.', 
                    //     });
                    // }

                    
                    if (meeting_check_in_city.toLowerCase() !== city.toLowerCase()) {
                        return res.status(201).json({ 
                            status: false, 
                            message: 'Check-in denied. You are not in the same city as the meeting location.', 
                        });
                    }

                    const meting_chkin_query = `UPDATE tbl_meeting SET meeting_check_in_status = 'yes', meeting_check_in_date_time = now(), meeting_check_in_latitude = $$${meeting_check_in_latitude}$$, meeting_check_in_longitude = $$${meeting_check_in_longitude}$$, meeting_check_in_full_address = $$${checkin_full_address}$$  where tbl_meeting_id = '${tbl_meeting_id}' AND tbl_user_id = '${tbl_user_id}' AND tbl_office_id = '${tbl_office_id}'`;

                    try {
                        const meetingupdtResult = await pool.query(meting_chkin_query);
                        if (meetingupdtResult.rowCount > 0) {
                            return res.status(201).json({ status: true, message: `Meeting check in successfully.` });
                        } else {
                            return res.status(500).json({ status: false, message: 'Failed to check in meeting.' });
                        }
                    } catch (err) {
                        console.error(err);
                        return res.status(500).json({ status: false, message: 'Error occurred while updating meeting.' });
                    }

                } else {
                    return res.status(500).json({ status: false, message: `This meeting is not approved, you can not check-in.` });
                }
            } else {
                return res.status(404).json({ status: false, message: 'meeting_id is wrong of this user.' });
            }
        } else {
            return res.status(404).json({ status: false, message: 'User not found' });
        }
    },
};
