const pg = require('pg');
const moment = require('moment');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const requests = require('request');
const serviceAccount = require("./wealthyfy-940a0-firebase-adminsdk-fbsvc-91b60ebd1a.json");
const admin = require('firebase-admin');

// Initialize the Firebase Admin SDK
admin.initializeApp({
    credential: admin.credential.cert(serviceAccount)
});

const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);


module.exports = {

    send_notification_to_user_by_firebase_token :  async(title, notification_message, notification_type, send_type, tbl_user_id, firebase_token, meeting_leave_id, parent_id )=> {

        // console.log('title', title);
        // console.log('notification_message', notification_message); 
        // const curnt_time  = moment().utcOffset("+05:30").format('LT');
        // console.log('curnt_time', curnt_time);
      
        const notifi_query =  await pool.query(`INSERT INTO tbl_notification(title, description, notification_type, send_type, tbl_user_id, meeting_leave_id, parent_id)VALUES('${title}', $$${notification_message}$$, '${notification_type}', '${send_type}', '${tbl_user_id}', '${meeting_leave_id}', '${parent_id}')`)

       // const  subcat = 'optional';
       // const  tbl_signal_id = '0';

        const message = {
            token: firebase_token,
            notification: {
                title: title,
                body: notification_message,
            },
            data : {
                //sub_category: subcat,
                //tbl_signal_id : tbl_signal_id
            }
        };

        admin.messaging().send(message)
        .then((response) => {
            console.log('Successfully sent message by firebase_token:', response);
            // console.log('Data sent:', message.data); // Log the data object after success
        })
        .catch((error) => {
            console.error('Error sending message:', error.message || error);
        });
    },

    send_notification_to_all_user :  async(title, notification_message,)=> {

        //console.log('title', title);
       // console.log('notification_message', notification_message);

        const notifi_query =  await pool.query(`INSERT INTO tbl_notification(title, description, notification_type, send_type, tbl_user_id)VALUES('${title}', $$${notification_message}$$, 'all', 'admin', '0')`)
        
        const topic = 'topics'; // Topic name
        // const subcat = 'car'; // Define the sub_cat variable
        // Function to send a push notification

        const message = {
            topic: topic, // Use topic instead of to
            notification: {
                title: title,
                body: notification_message,
            },
            data : {
              //  sub_category: subcat,
                // tbl_signal_id : tbl_signal_id
            }
        };
    
        admin.messaging().send(message)
        .then((response) => {
            console.log('Successfully sent message to all user:', response);
            // console.log('Data sent:', message.data); // Log the data object after success
        })
        .catch((error) => {
            console.error('Error sending message:', error);
        });
    },
};